package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddTag;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.*;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lizhiheng
 */
@Component
public class PddReqConverter {

    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddProperties dspPddProperties;

    public PddRequest reqConvert(AdxCommonBidRequest commonReq) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();

        // 广告位转换
        List<Imp> imps = impList.stream()
                .map(imp -> this.impConvert(imp, commonReq.getAdxType()))
                .collect(Collectors.toList());
        if (imps.isEmpty() || imps.size() == 1 && imps.contains(null)) {
            return null;
        }
        pddRequest.setImp(imps);

        pddRequest.setSite(new Site());
        pddRequest.setApp(this.appConvert(commonReq.getAppInfo()));
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
//        pddRequest.setExt();
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        if (Objects.isNull(userInfo)) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
//        user.setTag_id();
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
//        user.setConsume_level();
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
//        device.setIpv6();
        device.setDevicetype(commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setOs(commonDevice.getOs());
//        device.setOsv();
//        device.setH();
//        device.setW();
        // 这个不设置，因为每个媒体的枚举值都不一样，而且非必须
//        device.setConnectiontype(commonDevice.getConnectionType());
        device.setCarrier(commonDevice.getCarrier());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
//        device.setAndroidid();
//        device.setAndroidid_md5();
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
//        device.setCaid();
//        device.setPaid();
        device.setGeo(this.geoConvert(commonDevice.getGeo()));
//        device.setExt();
        return device;

    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        if (Objects.isNull(commonGeo)) {
            return geo;
        }
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(lat.floatValue()));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(leo.floatValue()));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        //这里app的信息加密一下 传给pdd
        app.setId(BlowfishUtils.encryptBlowfish(appInfo.getId()));
        app.setName(appInfo.getName());
        app.setBundle(appInfo.getBundle());
        app.setVersion(appInfo.getVersion());
//        app.setApp_scheme("");
        return app;
    }

    public Imp impConvert(CommonImp commonImp, Integer adxType) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return null;
        }
        ArrayList<Template> templates = new ArrayList<>();
        List<CommonSizeInfo> filteringSize = commonImp.getFilteringSize();
        if (filteringSize != null && !filteringSize.isEmpty()) {
            filteringSize.forEach(fs -> {
                PddTag pddTag = PddTag.getByStyleId(adxType, fs.getType(), fs.getHeight(), fs.getWidth());
                if (Objects.nonNull(pddTag)) {
                    imp.setTagid(pddTag.getTagId());
                    templates.add(new Template(pddTag.getTemplateId()));
                }
            });
            imp.setTemplates(templates);
        }
        if (templates.isEmpty()) {
            LOGGER.info("未找到对应pdd广告位，commonImp:{}", commonImp);
            return null;
        }
        imp.setId(commonImp.getId());

        // FIXME: 2022/7/11 暂时写死记得删除
//        imp.setTagid("tuia_nat_600*300");
//        imp.setTemplates(Collections.singletonList(new Template("tuia_nat_600*300")));
        imp.setBidfloor((int) Math.round(commonImp.getFloorPrice()));

        // 2.应用下载类,目前对接拼多多，只有下载类广告
        imp.setContent_type(Arrays.asList(1, 2));
//        imp.setKeyword();
//        imp.setDealid();
        imp.setSupport_deeplink(commonImp.isOpenDeepLink());
//        imp.setH();
//        imp.setW();
//        imp.setBcat();
//        imp.setWcat();
        //这里不需要传ext，因为是要和pdd约定的，众多媒体，约不过来
//        imp.setExt(commonImp.getExt());
        return imp;
    }
}
