/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddTag;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Geo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Site;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Template;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.User;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PddReqConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddProperties dspPddProperties;

    public PddRequest reqConvert(AdxCommonBidRequest commonReq) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(this.dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();
        List<Imp> imps = impList.stream().map(imp -> this.impConvert((CommonImp)imp, commonReq.getAdxType())).collect(Collectors.toList());
        if (imps.isEmpty() || imps.size() == 1 && imps.contains(null)) {
            return null;
        }
        pddRequest.setImp(imps);
        pddRequest.setSite(new Site());
        pddRequest.setApp(this.appConvert(commonReq.getAppInfo()));
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        if (Objects.isNull(userInfo)) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        device.setDevicetype(commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        device.setOs(commonDevice.getOs());
        device.setCarrier(commonDevice.getCarrier());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
        device.setGeo(this.geoConvert(commonDevice.getGeo()));
        return device;
    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        if (Objects.isNull(commonGeo)) {
            return geo;
        }
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(Float.valueOf(lat.floatValue())));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(Float.valueOf(leo.floatValue())));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        app.setId(BlowfishUtils.encryptBlowfish((String)appInfo.getId()));
        app.setName(appInfo.getName());
        app.setBundle(appInfo.getBundle());
        app.setVersion(appInfo.getVersion());
        return app;
    }

    public Imp impConvert(CommonImp commonImp, Integer adxType) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return null;
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        List<CommonSizeInfo> filteringSize = commonImp.getFilteringSize();
        if (filteringSize != null && !filteringSize.isEmpty()) {
            filteringSize.forEach(fs -> {
                PddTag pddTag = PddTag.getByStyleId(adxType, fs.getType(), fs.getHeight(), fs.getWidth());
                if (Objects.nonNull((Object)pddTag)) {
                    imp.setTagid(pddTag.getTagId());
                    templates.add(new Template(pddTag.getTemplateId()));
                }
            });
            imp.setTemplates(templates);
        }
        if (templates.isEmpty()) {
            LOGGER.info("\u672a\u627e\u5230\u5bf9\u5e94pdd\u5e7f\u544a\u4f4d\uff0ccommonImp:{}", (Object)commonImp);
            return null;
        }
        imp.setId(commonImp.getId());
        imp.setBidfloor((int)Math.round(commonImp.getFloorPrice()));
        imp.setContent_type(Arrays.asList(1, 2));
        imp.setSupport_deeplink(commonImp.isOpenDeepLink());
        return imp;
    }
}

