package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class RgyunDspInvoker extends AbstractDspCaller<RgyunBiddingResponse.RTBResponse, RgyunBiddingRequest.RTBRequest> {

    private static final String TOKEN = "d6797b0f95f8ead2";

    @Resource
    private RgyunRequestConverter rgyunRequestConverter;

    @Resource
    private RgyunResponseConverter rgyunResponseConverter;

    @Resource
    private RgyunProperties rgyunProperties;

    @Resource
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected RgyunBiddingResponse.RTBResponse invokeDsp(RgyunBiddingRequest.RTBRequest rtbRequest) {
        if(rtbRequest == null){
            return null;
        }
        if (rtbRequest.getImp() == null) {
            return null;
        }
        Cat.logMetricForCount("软告DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(rgyunProperties.getUrl(), rtbRequest), "invokeDSP", "rgyun");
        } catch (ResourceAccessException e) {
            log.warn("软告DSP,http请求异常,{}", e.getMessage());
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            log.error("软告DSP请求失败,{}", e.getMessage());
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            log.error("软告其他调用异常", e);
            return null;
        }
    }

    private RgyunBiddingResponse.RTBResponse doHttpInvoke(String url, RgyunBiddingRequest.RTBRequest rtbRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf");
        HttpEntity<byte[]> requestEntity = new HttpEntity<>(rtbRequest.toByteArray(), headers);
        SamplerLog.info("RgyunDspInvoker doHttpInvoke rtbRequest:{}", rtbRequest);
        ResponseEntity<org.springframework.core.io.Resource> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
        org.springframework.core.io.Resource resource = resEntity.getBody();
        if(resource == null){
            return null;
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        RgyunBiddingResponse.RTBResponse body = RgyunBiddingResponse.RTBResponse.parseFrom(resource.getInputStream());
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return body;
            } else {
                SamplerLog.info("软告DSP无内容返回,pddRequest[{}],body[{}]", rtbRequest, body);
                Cat.logMetricForCount("软告DSP返回2xx");
                return null;
            }
        } else if (statusCode.is5xxServerError()) {
            Cat.logMetricForCount("软告DSP返回5xx");
            SamplerLog.info("软告DSP返回5xx,pddRequest[{}],body[{}]", rtbRequest, body);
            return null;
        } else {
            Cat.logMetricForCount("软告DSP返回其他状态码");
            SamplerLog.info("软告DSP返回其他状态码,pddRequest[{}],body[{}]", rtbRequest, body);
            return null;
        }
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] raw = TOKEN.getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            IvParameterSpec iv = new IvParameterSpec(raw);
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
            byte[] encrypted = cipher.doFinal(price.toString().getBytes("utf-8"));
            byte[] encodeBase64 = Base64.encodeBase64URLSafe(encrypted);
            return new String(encodeBase64, "utf-8") ;
        }catch (Exception e){
            log.warn("RgyunDspInvoker 价格解密失败");
            return null;
        }
    }

    @Override
    public AdxCommonBidResponse doBid(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        return super.doBid(commonBidRequest, dspInfo);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_4.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_4;
    }

    @Override
    public RgyunBiddingRequest.RTBRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return rgyunRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(RgyunBiddingResponse.RTBResponse rtbResponse) throws DspException {
        try {
            return rgyunResponseConverter.respConvert(rtbResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        restTemplate.execute(url, HttpMethod.GET, null, null);
    }

    @Override
    public void doClickCallBack(String url) {
        restTemplate.execute(url, HttpMethod.GET, null, null);
    }

    @Override
    public void doExposureCallBack(String url) {
        restTemplate.execute(url, HttpMethod.GET, null, null);
    }
}
