package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import org.apache.commons.lang3.StringUtils;

public class DeviceConvert {
    public static TanxBiddingRequest.Request.Device convertDevice(AdxCommonBidRequest adxCommonBidRequest) {
        TanxBiddingRequest.Request.Device.Builder builder = TanxBiddingRequest.Request.Device.newBuilder();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setIp(device.getIp());
        builder.setUserAgent(device.getUa());
        if (StringUtils.isNotEmpty(device.getImeiMd5())) {
            builder.setImeiMd5(StringUtils.upperCase(device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaIdMd5())) {
            builder.setOaidMd5(StringUtils.upperCase(device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty(device.getIdFaMd5())) {
            builder.setIdfaMd5(StringUtils.upperCase(device.getIdFaMd5()));
        }
        builder.setOaid(device.getOaId());
        builder.setDeviceType(0);
        builder.setBrand(device.getMake());
        builder.setModel(device.getModel());
        builder.setOs(OsConvert.getOsType(device.getOs()));
        builder.setOsv(device.getOsVersion());
        builder.setNetwork(ConnectionTypeConvert.convertConnectionType(device.getTuiaConnectionType()));
        return builder.build();
    }
}
