/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleClickCrypto {
    private static final Logger log = LoggerFactory.getLogger(DoubleClickCrypto.class);
    public static final String KEY_ALGORITHM = "HmacSHA1";
    public static final int INITV_BASE = 0;
    public static final int INITV_SIZE = 16;
    public static final int INITV_TIMESTAMP_OFFSET = 0;
    public static final int INITV_SERVERID_OFFSET = 8;
    public static final int PAYLOAD_BASE = 16;
    public static final int SIGNATURE_SIZE = 4;
    public static final int OVERHEAD_SIZE = 20;
    private static final int COUNTER_PAGESIZE = 20;
    private static final int COUNTER_SECTIONS = 769;
    private static final int MICROS_PER_CURRENCY_UNIT = 1000000;
    private final Keys keys;

    public DoubleClickCrypto(Keys keys) {
        this.keys = keys;
    }

    @Nullable
    protected byte[] decode(@Nullable String data) {
        return data == null ? null : Base64.getUrlDecoder().decode(data);
    }

    @Nullable
    protected String encode(@Nullable byte[] data) {
        return data == null ? null : Base64.getUrlEncoder().encodeToString(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] cipherData) throws SignatureException {
        Preconditions.checkArgument((cipherData.length >= 20 ? 1 : 0) != 0, (String)"Invalid cipherData, %s bytes", (int)cipherData.length);
        byte[] workBytes = (byte[])cipherData.clone();
        ByteBuffer workBuffer = ByteBuffer.wrap(workBytes);
        boolean success = false;
        try {
            this.xorPayloadToHmacPad(workBytes);
            int confirmationSignature = this.hmacSignature(workBytes);
            int integritySignature = workBuffer.getInt(workBytes.length - 4);
            workBuffer.putInt(workBytes.length - 4, confirmationSignature);
            if (confirmationSignature != integritySignature) {
                throw new SignatureException("Signature mismatch: " + Integer.toHexString(confirmationSignature) + " vs " + Integer.toHexString(integritySignature));
            }
            if (log.isDebugEnabled()) {
                log.debug(DoubleClickCrypto.dump("Decrypted", cipherData, workBytes));
            }
            success = true;
            byte[] byArray = workBytes;
            return byArray;
        }
        finally {
            if (!success && log.isDebugEnabled()) {
                log.debug(DoubleClickCrypto.dump("Decrypted (failed)", cipherData, workBytes));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] plainData) {
        Preconditions.checkArgument((plainData.length >= 20 ? 1 : 0) != 0, (String)"Invalid plainData, %s bytes", (int)plainData.length);
        byte[] workBytes = (byte[])plainData.clone();
        ByteBuffer workBuffer = ByteBuffer.wrap(workBytes);
        boolean success = false;
        try {
            int signature = this.hmacSignature(workBytes);
            workBuffer.putInt(workBytes.length - 4, signature);
            this.xorPayloadToHmacPad(workBytes);
            if (log.isDebugEnabled()) {
                log.debug(DoubleClickCrypto.dump("Encrypted", plainData, workBytes));
            }
            success = true;
            byte[] byArray = workBytes;
            return byArray;
        }
        finally {
            if (!success && log.isDebugEnabled()) {
                log.debug(DoubleClickCrypto.dump("Encrypted (failed)", plainData, workBytes));
            }
        }
    }

    public byte[] createInitVector(@Nullable Date timestamp, long serverId) {
        return this.createInitVector(timestamp == null ? 0L : DoubleClickCrypto.millisToSecsAndMicros(timestamp.getTime()), serverId);
    }

    public byte[] createInitVector(long timestamp, long serverId) {
        byte[] initVector = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(initVector);
        byteBuffer.putLong(0, timestamp);
        byteBuffer.putLong(8, serverId);
        return initVector;
    }

    public Date getTimestamp(byte[] data) {
        long secondsAndMicros = ByteBuffer.wrap(data).getLong(0);
        return new Date(DoubleClickCrypto.secsAndMicrosToMillis(secondsAndMicros));
    }

    public long getServerId(byte[] data) {
        return ByteBuffer.wrap(data).getLong(8);
    }

    protected byte[] initPlainData(int payloadSize, @Nullable byte[] initVector) {
        byte[] plainData = new byte[20 + payloadSize];
        if (initVector == null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(plainData);
            byteBuffer.putLong(0, DoubleClickCrypto.millisToSecsAndMicros(System.currentTimeMillis()));
            byteBuffer.putLong(8, ThreadLocalRandom.current().nextLong());
        } else {
            System.arraycopy(initVector, 0, plainData, 0, Math.min(16, initVector.length));
        }
        return plainData;
    }

    private void xorPayloadToHmacPad(byte[] workBytes) {
        int payloadSize = workBytes.length - 20;
        int sections = (payloadSize + 20 - 1) / 20;
        Preconditions.checkArgument((sections <= 769 ? 1 : 0) != 0, (String)"Payload is %s bytes, exceeds limit of %s", (int)payloadSize, (int)15380);
        Mac encryptionHmac = DoubleClickCrypto.createMac();
        byte[] pad = new byte[23];
        int counterSize = 0;
        for (int section = 0; section < sections; ++section) {
            int sectionBase = section * 20;
            int sectionSize = Math.min(payloadSize - sectionBase, 20);
            try {
                encryptionHmac.reset();
                encryptionHmac.init(this.keys.getEncryptionKey());
                encryptionHmac.update(workBytes, 0, 16);
                if (counterSize != 0) {
                    encryptionHmac.update(pad, 20, counterSize);
                }
                encryptionHmac.doFinal(pad, 0);
            }
            catch (InvalidKeyException | ShortBufferException e) {
                throw new IllegalStateException(e);
            }
            for (int i = 0; i < sectionSize; ++i) {
                int n = 16 + sectionBase + i;
                workBytes[n] = (byte)(workBytes[n] ^ pad[i]);
            }
            Arrays.fill(pad, 0, 20, (byte)0);
            if (counterSize != 0) {
                int n = 20 + counterSize - 1;
                pad[n] = (byte)(pad[n] + 1);
                if (pad[n] != 0) continue;
            }
            ++counterSize;
        }
    }

    private static Mac createMac() {
        try {
            return Mac.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private int hmacSignature(byte[] workBytes) {
        try {
            Mac integrityHmac = DoubleClickCrypto.createMac();
            integrityHmac.init(this.keys.getIntegrityKey());
            integrityHmac.update(workBytes, 16, workBytes.length - 20);
            integrityHmac.update(workBytes, 0, 16);
            return Ints.fromByteArray((byte[])integrityHmac.doFinal());
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String dump(String header, byte[] inData, byte[] workBytes) {
        ByteBuffer initvBuffer = ByteBuffer.wrap(workBytes, 0, 16);
        Date timestamp = new Date(initvBuffer.getLong(0));
        long serverId = initvBuffer.getLong(8);
        return header + ": initVector={timestamp " + DateFormat.getDateTimeInstance().format(timestamp) + ", serverId " + serverId + "}, input =" + BaseEncoding.base16().encode(inData) + ", output =" + BaseEncoding.base16().encode(workBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("keys", (Object)this.keys).toString();
    }

    private static long millisToSecsAndMicros(long timestamp) {
        return timestamp / 1000L << 32 | timestamp % 1000L * 1000L;
    }

    private static long secsAndMicrosToMillis(long secondsAndMicros) {
        return (secondsAndMicros >> 32) * 1000L + (secondsAndMicros & 0xFFFFFFFFL) / 1000L;
    }

    public static class Hyperlocal
    extends DoubleClickCrypto {
        @Inject
        public Hyperlocal(Keys keys) {
            super(keys);
        }

        public byte[] encryptHyperlocal(byte[] hyperlocalPlain, @Nullable byte[] initVector) {
            byte[] plainData = this.initPlainData(hyperlocalPlain.length, initVector);
            System.arraycopy(hyperlocalPlain, 0, plainData, 16, hyperlocalPlain.length);
            return this.encrypt(plainData);
        }

        public byte[] decryptHyperlocal(byte[] hyperlocalCipher) throws SignatureException {
            byte[] plainData = this.decrypt(hyperlocalCipher);
            return Arrays.copyOfRange(plainData, 16, plainData.length - 4);
        }
    }

    public static class Idfa
    extends DoubleClickCrypto {
        @Inject
        public Idfa(Keys keys) {
            super(keys);
        }

        public byte[] encryptIdfa(byte[] idfaPlain, @Nullable byte[] initVector) {
            byte[] plainData = this.initPlainData(idfaPlain.length, initVector);
            System.arraycopy(idfaPlain, 0, plainData, 16, idfaPlain.length);
            return this.encrypt(plainData);
        }

        public byte[] decryptIdfa(byte[] idfaCipher) throws SignatureException {
            byte[] plainData = this.decrypt(idfaCipher);
            return Arrays.copyOfRange(plainData, 16, plainData.length - 4);
        }

        public String encodeIdfa(byte[] idfaPlain, @Nullable byte[] initVector) {
            return this.encode(this.encryptIdfa(idfaPlain, initVector));
        }

        public byte[] decodeIdfa(String idfaCipher) throws SignatureException {
            return this.decryptIdfa(this.decode(idfaCipher));
        }
    }

    public static class AdId
    extends DoubleClickCrypto {
        private static final int PAYLOAD_SIZE = 16;

        @Inject
        public AdId(Keys keys) {
            super(keys);
        }

        public byte[] encryptAdId(byte[] adidPlain, @Nullable byte[] initVector) {
            Preconditions.checkArgument((adidPlain.length == 16 ? 1 : 0) != 0, (String)"AdId is %s bytes, should be %s", (int)adidPlain.length, (int)16);
            byte[] plainData = this.initPlainData(16, initVector);
            System.arraycopy(adidPlain, 0, plainData, 16, 16);
            return this.encrypt(plainData);
        }

        public byte[] decryptAdId(byte[] adidCipher) throws SignatureException {
            Preconditions.checkArgument((adidCipher.length == 36 ? 1 : 0) != 0, (String)"AdId is %s bytes, should be %s", (int)adidCipher.length, (int)36);
            byte[] plainData = this.decrypt(adidCipher);
            return Arrays.copyOfRange(plainData, 16, plainData.length - 4);
        }
    }

    public static class Price
    extends DoubleClickCrypto {
        private static final int PAYLOAD_SIZE = 8;

        @Inject
        public Price(Keys keys) {
            super(keys);
        }

        public byte[] encryptPriceMicros(long priceValue, @Nullable byte[] initVector) {
            byte[] plainData = this.initPlainData(8, initVector);
            ByteBuffer.wrap(plainData).putLong(16, priceValue);
            return this.encrypt(plainData);
        }

        public long decryptPriceMicros(byte[] priceCipher) throws SignatureException {
            Preconditions.checkArgument((priceCipher.length == 28 ? 1 : 0) != 0, (String)"Price is %s bytes, should be %s", (int)priceCipher.length, (int)28);
            byte[] plainData = this.decrypt(priceCipher);
            return ByteBuffer.wrap(plainData).getLong(16);
        }

        public String encodePriceMicros(long priceMicros, @Nullable byte[] initVector) {
            return this.encode(this.encryptPriceMicros(priceMicros, initVector));
        }

        public String encodePriceValue(double priceValue, @Nullable byte[] initVector) {
            return this.encodePriceMicros((long)(priceValue * 1000000.0), initVector);
        }

        public long decodePriceMicros(String priceCipher) throws SignatureException {
            return this.decryptPriceMicros(this.decode((String)Preconditions.checkNotNull((Object)priceCipher)));
        }

        public double decodePriceValue(String priceCipher) throws SignatureException {
            return (double)this.decodePriceMicros(priceCipher) / 1000000.0;
        }
    }

    public static class Keys {
        private final SecretKey encryptionKey;
        private final SecretKey integrityKey;

        public Keys(SecretKey encryptionKey, SecretKey integrityKey) throws InvalidKeyException {
            this.encryptionKey = encryptionKey;
            this.integrityKey = integrityKey;
            Mac hmac = DoubleClickCrypto.createMac();
            hmac.init(encryptionKey);
            hmac.reset();
            hmac.init(integrityKey);
            hmac.reset();
        }

        public SecretKey getEncryptionKey() {
            return this.encryptionKey;
        }

        public SecretKey getIntegrityKey() {
            return this.integrityKey;
        }

        public int hashCode() {
            return this.encryptionKey.hashCode() ^ this.integrityKey.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Keys)) {
                return false;
            }
            Keys other = (Keys)obj;
            return this.encryptionKey.equals(other.encryptionKey) && this.integrityKey.equals(other.integrityKey);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("encryptionKey", (Object)(this.encryptionKey.getAlgorithm() + '/' + this.encryptionKey.getFormat())).add("integrityKey", (Object)(this.integrityKey.getAlgorithm() + '/' + this.integrityKey.getFormat())).toString();
        }
    }
}

