/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.FilterMaterInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.ConnectionTypeConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.OsConvert;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MoYiRequestConvert {
    private static final Logger log = LoggerFactory.getLogger(MoYiRequestConvert.class);
    public final String ANDROID = "0";
    public final String IOS = "1";
    public static final String MOVE = "1";
    public static final String UNICOM = "2";
    public static final String TELECOM = "3";

    public MoYiBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MoYiBidRequest builder = new MoYiBidRequest();
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setAuctionType(2);
        this.convertImp(builder, adxCommonBidRequest, dspInfo);
        this.convertApp(builder, adxCommonBidRequest, dspInfo);
        this.convertDevice(builder, adxCommonBidRequest);
        return builder;
    }

    public void convertImp(MoYiBidRequest builder, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonSizeInfo commonSizeInfo;
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        MoYiBidRequest.Imp imp = new MoYiBidRequest.Imp();
        List<CommonSizeInfo> filteringSize = this.filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());
        if (CollectionUtils.isNotEmpty(filteringSize)) {
            commonSizeInfo = filteringSize.get(0);
            if (dspInfo.getDspTagId() != null) {
                imp.setTagid(dspInfo.getDspTagId());
            }
        }
        imp.setId(commonImp.getId());
        imp.setBidFloor((int)Math.round(commonImp.getFloorPrice()));
        imp.setAdTypes(commonImp.getContentTypes());
        commonSizeInfo = commonImp.getFilteringSize().get(0);
        imp.setW(commonSizeInfo.getWidth());
        imp.setH(commonSizeInfo.getHeight());
        builder.setImp(Collections.singletonList(imp));
    }

    public String getOsType(String os) {
        if (StringUtils.isBlank((CharSequence)os)) {
            return "unknown";
        }
        switch (os) {
            case "0": {
                return "Android";
            }
            case "1": {
                return "iOS";
            }
        }
        return "unknown";
    }

    public Integer getCarrierType(String carrier) {
        if (StringUtils.isBlank((CharSequence)carrier)) {
            return 0;
        }
        switch (carrier) {
            case "1": {
                return 1;
            }
            case "2": {
                return 2;
            }
            case "3": {
                return 3;
            }
        }
        return 0;
    }

    public void convertDevice(MoYiBidRequest request, AdxCommonBidRequest adxCommonBidRequest) {
        MoYiBidRequest.Device builder = new MoYiBidRequest.Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setIp(device.getIp());
        builder.setUa(device.getUa());
        builder.setWebViewUa(device.getUa());
        if (StringUtils.isNotEmpty((CharSequence)device.getImeiMd5())) {
            builder.setImeiMd5(StringUtils.upperCase((String)device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getOaIdMd5())) {
            builder.setOaidMd5(StringUtils.upperCase((String)device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getIdFaMd5())) {
            builder.setIdfaMd5(StringUtils.upperCase((String)device.getIdFaMd5()));
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getOaId())) {
            builder.setOaid(device.getOaId());
        }
        builder.setDeviceType(1);
        builder.setBrand(device.getMake());
        builder.setModel(device.getModel());
        builder.setOs(OsConvert.getOsType(device.getOs()));
        builder.setOsv(device.getOsVersion());
        builder.setMake(device.getMake());
        builder.setCarrier(this.getCarrierType(device.getCarrier()));
        builder.setConnectionType(ConnectionTypeConvert.convertConnectionType(device.getTuiaConnectionType()));
        MoYiBidRequest.Geo geo = new MoYiBidRequest.Geo();
        if (Objects.nonNull(device.getGeo())) {
            geo.setCity(device.getGeo().getCity());
            geo.setLon(device.getGeo().getLon().floatValue());
            geo.setLat(device.getGeo().getLat().floatValue());
        }
        request.setDevice(builder);
        request.getDevice().setGeo(geo);
    }

    public void convertApp(MoYiBidRequest request, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MoYiBidRequest.App builder = new MoYiBidRequest.App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        builder.setPackageName(appInfo.getBundle());
        builder.setName(appInfo.getName());
        builder.setVer(appInfo.getVersion());
        request.setApp(builder);
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        ArrayList commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = this.matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (!Objects.nonNull(commonSizeInfo1)) continue;
            commonSizeInfos.add(commonSizeInfo1);
        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (!filterMaterInfo.getWidth().equals(width) || !filterMaterInfo.getHeight().equals(height)) continue;
            return commonSizeInfo;
        }
        return null;
    }
}

