/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MoYiResponseConvert {
    private static final Logger log = LoggerFactory.getLogger(MoYiResponseConvert.class);

    public AdxCommonBidResponse respConvert(MoYiBidResponse response) {
        if (response == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_7.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response.getSeatBids());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<MoYiBidResponse.SeatBid> seatList) {
        MoYiBidResponse.Material material;
        MoYiBidResponse.Bid bid;
        MoYiBidResponse.Ext ext;
        MoYiBidResponse.SeatBid seatBid;
        ArrayList commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        if (CollectionUtils.isNotEmpty(seatList) && CollectionUtils.isNotEmpty((seatBid = seatList.get(0)).getBid()) && Objects.nonNull(ext = (bid = seatBid.getBid().get(0)).getExt()) && Objects.nonNull(material = ext.getMaterial())) {
            CommonCreative commonCreative = new CommonCreative();
            commonSeatBid.setCommonCreative(commonCreative);
            commonSeatBid.setPrice(Double.parseDouble(String.valueOf(bid.getPrice())));
            commonSeatBid.setAdvertiserId("");
            if (Objects.nonNull(ext.getTracking())) {
                MoYiBidResponse.Tracking tracking = ext.getTracking();
                commonSeatBid.setWinCallbackUrls(tracking.getPnurl());
                commonSeatBid.setExposureCallbackUrls(tracking.getReportImpress());
                commonSeatBid.setClickCallbackUrls(tracking.getReportClick());
            }
            commonCreative.setLandingPageUrl(material.getLdp());
            commonCreative.setCreativeId(bid.getId());
            commonCreative.setDeepLinkUrl(material.getDurl());
            context.setDeepLinkUrl(material.getDurl());
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(material.getTitle());
            commonCreative.setCommonTitle(commonTitle);
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(material.getDesc());
            commonCreative.setCommonDesc(commonDesc);
            if (Objects.equals(material.getAdType(), 1) || Objects.equals(material.getAdType(), 6)) {
                ArrayList<CommonImage> imageList = new ArrayList<CommonImage>();
                CommonImage image = new CommonImage();
                List<MoYiBidResponse.Image> images = material.getImages();
                if (CollectionUtils.isNotEmpty(images)) {
                    MoYiBidResponse.Image image1 = images.get(0);
                    image.setUrl(image1.getUrl());
                    image.setWidth(Integer.valueOf(StringUtils.isNotBlank((CharSequence)image1.getWidth()) ? image1.getWidth() : "0"));
                    image.setHeight(Integer.valueOf(StringUtils.isNotBlank((CharSequence)image1.getHeight()) ? image1.getHeight() : "0"));
                }
                imageList.add(image);
                commonCreative.setCommonImageList(imageList);
            }
            if (Objects.equals(material.getAdType(), 2)) {
                ArrayList<CommonVideo> videoList = new ArrayList<CommonVideo>();
                CommonVideo video = new CommonVideo();
                List<MoYiBidResponse.Video> videos = material.getVideo();
                if (CollectionUtils.isNotEmpty(videos)) {
                    MoYiBidResponse.Video video1 = videos.get(0);
                    video.setVideoUrl(video1.getVideoUrl());
                    video.setCoverUrl(video1.getVideoImg());
                    video.setDuration(BigDecimal.valueOf(video1.getDuration()));
                }
                videoList.add(video);
                commonCreative.setCommonVideoList(videoList);
            }
        }
        return commonSeatBidList;
    }
}

