package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;


import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.constants.PddNbr;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddReqConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddRespConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

/**
 * @author Wangpf
 * @date 2022/7/1 10:14 上
 */
@Component
@EnableConfigurationProperties(PddProperties.class)
public class PddDspInvoker extends AbstractDspCaller<PddResponse, PddRequest> {

    public static final String jsonStr = "{\n" +
            "    \"adx_id\":\"mrk_union_imb\",\n" +
            "    \"request_id\":\"1\",\n" +
            "    \"bid_id\":\"f79103137bb04105bc74ccac5101401c\",\n" +
            "    \"seatbid\":[\n" +
            "        {\n" +
            "            \"bid\":[\n" +
            "                {\n" +
            "                    \"id\":\"f79103137bb04105bc74ccac5101401c_0\",\n" +
            "                    \"impid\":\"1_1\",\n" +
            "                    \"tagid\":\"\",\n" +
            "                    \"template_id\":\"1.4.1\",\n" +
            "                    \"price\":60000,\n" +
            "                    \"pdd_adid\":\"100157114726\",\n" +
            "                    \"nurl\":\"https://t-dsp.pinduoduo.com/dspcb/w/mrk_union?acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb_aff_splsh&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&st0=-1&st1=2&goods_id=&price_st=-1&lx=1&lxt=99&bundle=com.filemagic&did=8356c484baee55db3144931bd2b3bfc6&price=%%PRICE%%&os=android&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&display_id=151&source=3&y19=54091&sub_channel=mrk_union_imb\",\n" +
            "                    \"iurl\":[\n" +
            "                        \"https://t-dsp.pinduoduo.com/dspcb/i/mrk_union?pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb_aff_splsh&os=android&did=8356c484baee55db3144931bd2b3bfc6&acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&st0=-1&st1=2&price_st=-1&lx=1&lxt=99&goods_id=&bundle=com.filemagic&price=%%PRICE%%&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&v_cat=-2&display_id=151&source=3&pctr=0.00000&y19=54091&sub_channel=mrk_union_imb\"\n" +
            "                    ],\n" +
            "                    \"curl\":[\n" +
            "                        \"https://at.pinduoduo.com/a/mrk_union?acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&launch_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb10/21媒体广告平台接入拼多多外投广告技术规范_aff_splsh&os=android&did=8356c484baee55db3144931bd2b3bfc6&goods_id=&st0=-1&st1=2&lx=1&lxt=99&price_st=-1&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&bundle=com.filemagic&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&v_cat=-2&display_id=151&source=3&pcvr=0.00000&sub_channel=mrk_union_imb&imei=8356c484baee55db3144931bd2b3bfc6&oaid=8356c484baee55db3144931bd2b3bfc6&y19=54091\",\n" +
            "                        \"https://t-dsp.pinduoduo.com/dspcb/c/mrk_union?acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&launch_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb_aff_splsh&os=android&did=8356c484baee55db3144931bd2b3bfc6&goods_id=&st0=-1&st1=2&lx=1&lxt=99&price_st=-1&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&bundle=com.filemagic&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&v_cat=-2&display_id=151&source=3&pcvr=0.00000&sub_channel=mrk_union_imb&imei=8356c484baee55db3144931bd2b3bfc6&oaid=8356c484baee55db3144931bd2b3bfc6&y19=54091\"\n" +
            "                    ],\n" +
            "                    \"click_url\":\"https://lp.pinduoduo.com/poros/h5?vst_scene=pdv&acc=100001&soid=56c4210acf37915fc10100004e0300006e42a0ff&ads_channel=mrk_union&display_id=151&source=3&lx=1&creative_id=100157114726&ads_csite=imb_aff_splsh&price_st=-1&cate1_id=0&bundle=com.filemagic&page_uid=909ded3c60174bf093868b4658b58fe1&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&y19=54091&os=android&src=mrk_union&abs_id=104629&lxt=99&st0=-1&st2=8356c484baee55db3144931bd2b3bfc6&ads_set=10000495&st1=2&st3=8356c484baee55db3144931bd2b3bfc6&ads_id=1000011693&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0\",\n" +
            "                    \"content_type\":1,\n" +
            "                    \"deeplink_url\":\"pddopen://pinduoduo?h5Url=mlp_land_nd.html%3F_p_acc%3D100001%26_p_source%3D3%26y19%3D54091%26_p_ads_set%3D10000495%26_p_launch_id%3Df79103137bb04105bc74ccac5101401c_0%26_p_cate1_id%3D0%26_p_ads_id%3D1000011693%26is_lego%3D1%26_p_launch_type%3Ddsp%26_p_creative_id%3D100157114726%26lego_url%3Dhttps%253A%252F%252Ft16img.yangkeduo.com%252Flego-bundle%252Flego%252Fad_land_20190820_161047_2_1_3.lego%253FpageName%253Dad_land%26jump_url%3Dmkt_daily999.html%26_p_pdd_bid_id%3Df79103137bb04105bc74ccac5101401c_0%26_p_display_id%3D151%26_oc_ads_channel%3Dmrk_union%26_p_soid%3D56c4210acf37915fc10100004e0300006e42a0ff%26_p_ads_channel%3Dmrk_union%26_p_ads_csite%3Dimb_aff_splsh%26lego_minversion%3D4.58.0&direct_back=true\",\n" +
            "                    \"app_name\":\"\\u62FC\\u591A\\u591A\",\n" +
            "                    \"app_bundle\":\"com.xunmeng.pinduoduo\",\n" +
            "                    \"adm\":{\n" +
            "                        \"title\":\"X\\u5927\\u989D\\u7EA2\\u5305\\uFF0C\\u7B49\\u4F60\\u6765\\u9886\",\n" +
            "                        \"image_url\":[\n" +
            "                            \"http://images.pinduoduo.com/marketing_api/2020-10-22/3a9c9023-ad82-477a-bb7e-1bd75321d4ab.jpeg\"\n" +
            "                        ]\n" +
            "                    }\n" +
            "                }\n" +
            "            ],\n" +
            "            \"seat\":\"pinduoduo\"\n" +
            "        }\n" +
            "    ],\n" +
            "    \"nbr\":0\n" +
            "}";
    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);

    @Resource
    PddReqConverter pddConverter;
    @Resource
    PddRespConverter pddRespConverter;

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Resource
    private PddProperties pddProperties;

    @Override
    public AdxCommonBidResponse doBid(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        return super.doBid(commonBidRequest, dspInfo);
    }

    @Override
    public PddRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return pddConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }

    }

    @Override
    protected PddResponse invokeDsp(PddRequest pddRequest) {
        if (pddRequest == null) {
            return null;
        }
        if (pddRequest.getImp() == null || pddRequest.getImp().isEmpty()) {
            return null;
        }
        Cat.logMetricForCount("拼多多DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(pddProperties.getUrl(), pddRequest), "invokeDSP", "pdd");
        } catch (ResourceAccessException e) {
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            LOGGER.error("拼多多其他调用异常", e);
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(pddProperties.getAdxSecret().getBytes(), "AES"));
            return new String(Base64.getEncoder().encode(cipher.doFinal(price.toString().getBytes())));
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | IllegalBlockSizeException | BadPaddingException e) {
            LOGGER.warn("{}价格解密失败,secret:{}", pddProperties.getAdxId(), pddProperties.getAdxSecret(), e);
            return null;
        }
    }

    /**
     * 发起http请求
     *
     * @param url
     */
    private PddResponse doHttpInvoke(String url, PddRequest pddRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<PddRequest> requestEntity = new HttpEntity<>(pddRequest, headers);
        ResponseEntity<PddResponse> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, PddResponse.class);
        HttpStatus statusCode = resEntity.getStatusCode();
        PddResponse body = resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            } else {
                SamplerLog.info("拼多多DSP无内容返回,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
                return null;
            }
        } else if (statusCode.is5xxServerError()) {
            LOGGER.warn("拼多多DSP返回5xx,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
            return null;
        } else {
            LOGGER.warn("拼多多DSP返回其他状态码,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
            return null;
        }

    }

    private PddResponse handle2xx(PddResponse pddResponse) {
        if (!pddResponse.getNbr().equals(0)) {
            SamplerLog.info("拼多多DSP返回为空:{}", JSONObject.toJSONString(pddResponse));
        }
        Integer val;
        if (Objects.isNull(val = pddResponse.getNbr())) {
            return null;
        }
        if (PddNbr.NBR_0.getNbr().equals(val)) {
            Cat.logMetricForCount("拼多多DSP返回");
        }
        return pddResponse;
    }

    @Override
    public AdxCommonBidResponse convertResp(PddResponse pddResponse) throws DspException {
        try {
            return pddRespConverter.respConvert(pddResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_3.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_3;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            url = url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }
}
