package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import cn.com.duiba.tuia.dsp.engine.api.util.UAUtils;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.util.*;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class RgyunRequestConverter {
    /**
     * 图片类型
     */
    private static final Integer BANNER_TYPTE = 1;
    /**
     * 视频类型
     */
    private static final Integer VIDEO_TYPE = 3;

    Map<String, String> appMap = new HashMap<>();

    {
        appMap.put("com.sdfsh", "com.safeluck.life");
        appMap.put("com.adhub.app", "com.duorong.smarttool");
        appMap.put("com.jiaxiao", "com.jxedt");
        appMap.put("com.hiyrr", "com.martian.ttbookhd");
        appMap.put("com.eghtht", "com.mendon.riza");
        appMap.put("com.fefe", "com.lishun.flyfish");
        appMap.put("com.ytx.era", "com.itcode.reader");
        appMap.put("com.lehfef", "com.aliyun.iot.living");
        appMap.put("com.dc.lotol", "com.vodone.know");
        appMap.put("com.adhub", "com.snda.lantern.wifilocating");
        appMap.put("com.jo.avi", "com.sevenVideo.app.android");
        appMap.put("com.zhangshang", "com.ichano.athome.camera");
        appMap.put("com.jooa", "com.zlkj.cjszgj");
        appMap.put("com.yy", "com.duowan.mobile");
    }

    public RgyunBiddingRequest.RTBRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        RgyunBiddingRequest.RTBRequest.Builder builder = RgyunBiddingRequest.RTBRequest.newBuilder();
        //设置site对象
        RgyunBiddingRequest.RTBRequest.SiteInfo siteInfo = RgyunBiddingRequest.RTBRequest.SiteInfo.newBuilder().setId("800390").setName("软告").build();
        builder.setSite(siteInfo);
        //设置imp对象
        builder.setImp(convertImp(adxCommonBidRequest, dspInfo));
        //设置app对象
        if (37506 == dspInfo.getIdeaId()) {
            RgyunBiddingRequest.RTBRequest.AppInfo appInfo = replaceApp(adxCommonBidRequest.getAppInfo());
            builder.setApp(appInfo);
        } else {
            builder.setApp(convertApp(adxCommonBidRequest.getAppInfo()));
        }

        //设置device对象
        builder.setDevice(convertDevice(adxCommonBidRequest.getDevice(), adxCommonBidRequest.getAdxType()));
        //设置user对象
        builder.setUser(convertUser(adxCommonBidRequest.getUserInfo()));
        builder.setId(adxCommonBidRequest.getRequestId());
        builder.setVersion("2.1.2");
        return builder.build();
    }

    private RgyunBiddingRequest.RTBRequest.UserInfo convertUser(CommonUserInfo userInfo) {
        RgyunBiddingRequest.RTBRequest.UserInfo.Builder userBuilder = RgyunBiddingRequest.RTBRequest.UserInfo.newBuilder();
        if (Objects.isNull(userInfo)) {
            return userBuilder.build();
        }
        userBuilder.setId(optionOfNull(userInfo.getId()));
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> userBuilder.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
        return userBuilder.build();
    }

    private RgyunBiddingRequest.RTBRequest.DeviceInfo convertDevice(CommonDevice device, Integer adxType) {
        RgyunBiddingRequest.RTBRequest.DeviceInfo.Builder deviceBuilder = RgyunBiddingRequest.RTBRequest.DeviceInfo.newBuilder();
        if (Objects.isNull(device)) {
            return deviceBuilder.build();
        }
        deviceBuilder.setImei(optionOfNull(device.getImei()));
        deviceBuilder.setImeimd5(optionOfNull(device.getImeiMd5()));
        deviceBuilder.setIdfa(optionOfNull(device.getIdFa()));
        deviceBuilder.setIdfamd5(optionOfNull(device.getIdFaMd5()));
        deviceBuilder.setIdfv(optionOfNull(device.getIdfv()));
        deviceBuilder.setOaid(optionOfNull(device.getOaId()));
        deviceBuilder.setOaidmd5(optionOfNull(device.getOaIdMd5()));
        deviceBuilder.setUa(optionOfNull(device.getUa()));
        deviceBuilder.setIp(optionOfNull(device.getIp()));
        UAData uaData = UAUtils.parseUA(device.getUa());
        //运营商 0：unkonwn；1：中国移劢；2：中国联通；3：中国电信
        deviceBuilder.setCarrier(CarrierConverter.getCarrierType(device.getCarrier()));
        deviceBuilder.setMake(getMaker(device.getMake(), uaData));

        deviceBuilder.setModel(getModel(device.getModel(), uaData));
        //操作系统 0：unknown；1：android；2：ios；3：harmonyos
        RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType osType = OsConverter.getOsType(device.getOs(), uaData);
        deviceBuilder.setOs(osType);
        setDeviceId(osType, deviceBuilder, device, adxType);
        //操作系统版本
        deviceBuilder.setOsv(OsvConverter.getOsvType(device.getUa()));
        //设备联网方式 0=unknown; 1=wifi; 2=2G;3=3G; 4=4G; 5=5G
        deviceBuilder.setConnectiontype(ConnectionTypeConverter.getConnectionType(device.getTuiaConnectionType()));
        //设备类型 PC 端为0; 1=iPhone ；2=iPad ；3=android；4=android_pad
        deviceBuilder.setDevicetype(DeviceTypeConverter.getDeviceType(device.getUa()));
        deviceBuilder.setMac(optionOfNull(device.getMac()));
        deviceBuilder.setGeo(geoConvert(device.getGeo()));
        return deviceBuilder.build();
    }

    private String getModel(String model, UAData uaData) {
        if (StringUtils.isNotBlank(model)) {
            return model;
        }
        if (Objects.nonNull(uaData)) {
            String model1 = uaData.getModel();
            if (StringUtils.isNotBlank(model1)) {
                return model1;
            }
        }
        return " ";
    }

    private String getMaker(String make, UAData uaData) {
        if (StringUtils.isNotBlank(make)) {
            return make;
        }
        if (Objects.nonNull(uaData)) {
            if (Objects.equals("Android", uaData.getOsType())) {
                return "huawei";
            } else {
                return "apple";
            }
        }
        return "unknow";
    }

    private void setDeviceId(RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType osType, RgyunBiddingRequest.RTBRequest.DeviceInfo.Builder deviceBuilder, CommonDevice device, Integer adxType) {
        if (!Integer.valueOf(19).equals(adxType)) {
            return;
        }
        switch (osType) {
            case OT_Android:
                if (StringUtils.isBlank(deviceBuilder.getOaid())) {
                    deviceBuilder.setOaid(optionOfNull(device.getTuiaDeviceId()));
                }
                break;
            case OT_Ios:
                if (StringUtils.isBlank(deviceBuilder.getImei()) && StringUtils.isBlank(deviceBuilder.getIdfa())) {
                    deviceBuilder.setImei(optionOfNull(device.getTuiaDeviceId()));
                }
                break;
            default:
                break;
        }
    }


    private RgyunBiddingRequest.RTBRequest.DeviceInfo.GeoInfo geoConvert(CommonGeo geo) {
        RgyunBiddingRequest.RTBRequest.DeviceInfo.GeoInfo.Builder geoBuilder = RgyunBiddingRequest.RTBRequest.DeviceInfo.GeoInfo.newBuilder();
        if (Objects.isNull(geo)) {
            return geoBuilder.build();
        }
        Optional.ofNullable(geo.getLat()).ifPresent(lat -> geoBuilder.setLat(lat.floatValue()));
        Optional.ofNullable(geo.getLon()).ifPresent(leo -> geoBuilder.setLon(leo.floatValue()));
        return geoBuilder.build();
    }

    private RgyunBiddingRequest.RTBRequest.AppInfo replaceApp(CommonAppInfo commonAppInfo) {
        RgyunBiddingRequest.RTBRequest.AppInfo.Builder builder = RgyunBiddingRequest.RTBRequest.AppInfo.newBuilder();
        String appId = BlowfishUtils.encryptBlowfish(StringUtils.isBlank(commonAppInfo.getId()) ? "YQFDSG" : commonAppInfo.getId());
        if (appMap.containsKey(commonAppInfo.getBundle())) {
            String bundle = appMap.get(commonAppInfo.getBundle());
            builder.setBundle(bundle);
            builder.setName(commonAppInfo.getName());
            builder.setId(appId);
            return builder.build();
        }
        Random random = new Random();
        int i = random.nextInt(appMap.size());
        String budle = appMap.values().stream().skip(i).findFirst().get();
        builder.setBundle(budle);
        builder.setName(commonAppInfo.getName());
        builder.setId(appId);
        return builder.build();
    }

    private RgyunBiddingRequest.RTBRequest.AppInfo convertApp(CommonAppInfo appInfo) {
        RgyunBiddingRequest.RTBRequest.AppInfo.Builder appInfoBuilder = RgyunBiddingRequest.RTBRequest.AppInfo.newBuilder();
        if (Objects.nonNull(appInfo)) {
            appInfoBuilder.setId(BlowfishUtils.encryptBlowfish(StringUtils.isBlank(appInfo.getId()) ? "YQFDSG" : appInfo.getId()));
            appInfoBuilder.setName(appInfo.getName());
            appInfoBuilder.setBundle(appInfo.getBundle());
        } else {
            appInfoBuilder.setId(BlowfishUtils.encryptBlowfish("YQFDSG"));
            appInfoBuilder.setName("推啊");
            appInfoBuilder.setBundle("com.tuia");
        }
        return appInfoBuilder.build();
    }


    private RgyunBiddingRequest.RTBRequest.ImpInfo convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        RgyunBiddingRequest.RTBRequest.ImpInfo.Builder impInfoBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.newBuilder();
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) {
            return impInfoBuilder.build();
        }
        CommonImp commonImp = impList.get(0);
        impInfoBuilder.setId(optionOfNull(commonImp.getId()));
        List<CommonSizeInfo> filteringSize = filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());

        if (CollectionUtils.isNotEmpty(filteringSize)) {
            CommonSizeInfo commonSizeInfo = filteringSize.get(0);
            List<String> templateIds = Lists.newArrayList();
            if (dspInfo.getDspTagId() != null) {
                impInfoBuilder.setTagid(dspInfo.getDspTagId());
            }
            if (dspInfo.getDspTemplateId() != null) {
                templateIds.add(dspInfo.getDspTemplateId());
            }
            impInfoBuilder.addAllTemplateIds(templateIds);
            Integer type = commonSizeInfo.getType();
            Integer pos = null;
            if (StringUtils.isNotBlank(dspInfo.getDspResId())) {
                pos = Integer.valueOf(dspInfo.getDspResId());
            }
            if (CollectionUtils.isEmpty(impInfoBuilder.getTemplateIdsList())) {
                log.warn("未找到对应光告广告位，commonImp", JSON.toJSONString(commonImp));
                return impInfoBuilder.build();
            }
            if (BANNER_TYPTE.equals(type)) {
                RgyunBiddingRequest.RTBRequest.ImpInfo.BannerInfo.Builder bannerBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.BannerInfo.newBuilder();
                bannerBuilder.setW(commonSizeInfo.getWidth());
                bannerBuilder.setH(commonSizeInfo.getHeight());
                if (pos != null) {
                    bannerBuilder.setPos(RgyunBiddingRequest.RTBRequest.ImpInfo.PosType.forNumber(pos));
                }
                //设置banner对象
                impInfoBuilder.setBanner(bannerBuilder.build());
            } else if (VIDEO_TYPE.equals(type)) {
                RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.Builder videoBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.newBuilder();
                videoBuilder.setW(commonSizeInfo.getWidth());
                videoBuilder.setH(commonSizeInfo.getHeight());
                if (pos != null) {
                    videoBuilder.setPos(RgyunBiddingRequest.RTBRequest.ImpInfo.PosType.forNumber(pos));
                }
                videoBuilder.setMinduration(Optional.ofNullable(commonSizeInfo.getMinduration()).orElse(5));
                videoBuilder.setMaxduration(Optional.ofNullable(commonSizeInfo.getMaxduration()).orElse(30));
                RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.VideoCover.Builder coverBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.VideoCover.newBuilder();
                coverBuilder.setCovertype(RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.VideoCover.CoverType.IMAGE);
                //设置cover对象
                videoBuilder.setCover(coverBuilder.build());
                //设置video对象
                impInfoBuilder.setVideo(videoBuilder.build());
            } else {
                log.warn("软告dsp convertImp 无法识别是banner 还是 video");
                return impInfoBuilder.build();
            }
        }
        impInfoBuilder.setId(commonImp.getId());
        long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100)) + 1;
        impInfoBuilder.setBidfloor(bidFloor);
        return impInfoBuilder.build();
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        List<CommonSizeInfo> commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (Objects.nonNull(commonSizeInfo1)) {
                commonSizeInfos.add(commonSizeInfo1);
            }

        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (filterMaterInfo.getWidth().equals(width) && filterMaterInfo.getHeight().equals(height)) {
                return commonSizeInfo;
            }
        }
        return null;
    }

    private String optionOfNull(String param) {
        return Optional.ofNullable(param).orElse("");
    }
}
