/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.tuia.dsp.engine.api.config.DspRateLimiter;
import cn.com.duiba.tuia.dsp.engine.api.config.RateLimiterProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.DspFacadeInterface;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.filter.AdvertConditionFilterHolder;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DspFacade
extends DspFacadeInterface
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DspFacade.class);
    private ApplicationContext applicationContext;
    @Resource
    ExecutorService outDspExecutorService;
    @Resource
    RateLimiterProperties rateLimiterProperties;
    @Resource
    DspRateLimiter rateLimiter;
    private final Map<Integer, AbstractDspCaller> dspCallerMap = new HashMap<Integer, AbstractDspCaller>();
    @Autowired
    private AdvertConditionFilterHolder advertConditionFilterHolder;
    private static final Logger LOGGER = LoggerFactory.getLogger(DspFacade.class);

    @Override
    public AdxCommonBidResponse doInvoke(AdxCommonBidRequest adxCommonBidRequest, List<DspInfo> dspInfos) throws DspException {
        dspInfos = this.advertConditionFilterHolder.filter(dspInfos);
        List<AdxCommonBidResponse> adxCommonBidResponses = this.generateFutures(adxCommonBidRequest, dspInfos);
        return this.comparePrice(adxCommonBidResponses);
    }

    @Override
    public String priceEncryption(BigDecimal price, Integer dspId) {
        AbstractDspCaller caller = this.getDspByDspId(dspId);
        return caller.priceEncryption(price);
    }

    @Override
    public String replaceUrl(String price, String url, Integer dspId) {
        AbstractDspCaller caller = this.getDspByDspId(dspId);
        return caller.replaceUrl(price, url);
    }

    @Override
    public void doWinCallBack(String url, Integer dspId) {
        AbstractDspCaller caller = this.getDspByDspId(dspId);
        caller.doWinCallBack(url);
        log.info("notifyOutDsp doWinCallBack outDspId is {} url is {}", (Object)dspId, (Object)url);
    }

    @Override
    public void doClickCallBack(String url, Integer dspId) {
        AbstractDspCaller caller = this.getDspByDspId(dspId);
        caller.doClickCallBack(url);
        log.info("notifyOutDsp doClickCallBack outDspId is {} url is {}", (Object)dspId, (Object)url);
    }

    @Override
    public void doExposureCallBack(String url, Integer dspId) {
        AbstractDspCaller caller = this.getDspByDspId(dspId);
        caller.doExposureCallBack(url);
        log.info("notifyOutDsp doExposureCallBack outDspId is {} url is {}", (Object)dspId, (Object)url);
    }

    public List<AdxCommonBidResponse> generateFutures(AdxCommonBidRequest adxCommonBidRequest, List<DspInfo> dspInfos) {
        if (CollectionUtils.isEmpty(dspInfos)) {
            return null;
        }
        if (this.rateLimiter.getRateLimiter().tryAcquire((long)this.rateLimiterProperties.getRequireTimeout().intValue(), TimeUnit.MICROSECONDS)) {
            ArrayList futures = new ArrayList();
            dspInfos.forEach(dspInfo -> {
                AbstractDspCaller dspCaller = this.getDspByDspId(dspInfo.getDspId());
                CompletableFuture<AdxCommonBidResponse> adxCommonBidResponseCompletableFuture = CompletableFuture.supplyAsync(() -> dspCaller.doBid(adxCommonBidRequest, (DspInfo)dspInfo), this.outDspExecutorService);
                futures.add(adxCommonBidResponseCompletableFuture);
            });
            try {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(this.rateLimiterProperties.getFutureTimeOut().intValue(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                Cat.logMetricForCount((String)"DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u8d85\u65f6");
            }
            catch (InterruptedException e) {
                Cat.logMetricForCount((String)"DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u4e2d\u65ad");
            }
            catch (Exception e) {
                Cat.logMetricForCount((String)"DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u5931\u8d25");
                LOGGER.warn("DSP\u5e76\u884c\u8bf7\u6c42\u603b\u7ebf\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
            return futures.stream().map(future -> {
                try {
                    AdxCommonBidResponse now = future.getNow(null);
                    if (now != null) {
                        return now;
                    }
                }
                catch (Exception e) {
                    Cat.logMetricForCount((String)"DSP\u8bf7\u6c42\u5355\u4e2aDSP\u5931\u8d25");
                    LOGGER.warn("DSP\u8bf7\u6c42\u5355\u4e2aDSP\u5931\u8d25", (Throwable)e);
                }
                return null;
            }).collect(Collectors.toList());
        }
        Cat.logMetricForCount((String)"DSP\u9650\u6d41");
        int i = (int)(Math.random() * 10000.0);
        if (i <= 1) {
            LOGGER.info("DSP\u8bf7\u6c42\u9650\u6d41\uff0c\u8d85\u8fc7\u9608\u503c\uff0c{}\u4e2a/s", (Object)this.rateLimiterProperties.getTokenPerSec());
        }
        return null;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public AbstractDspCaller getDspByDspId(Integer dspId) {
        AbstractDspCaller dspCaller = this.dspCallerMap.get(dspId);
        if (dspCaller != null) {
            return dspCaller;
        }
        dspCaller = (AbstractDspCaller)this.applicationContext.getBean(DspEnum.getByDspId(dspId).getClazz());
        this.dspCallerMap.put(dspId, dspCaller);
        return dspCaller;
    }
}

