/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Geo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Site;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.Template;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.User;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PddReqConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddProperties dspPddProperties;
    Map<String, String> appMap = new HashMap<String, String>();

    public PddReqConverter() {
        this.appMap.put("com.sdfsh", "com.safeluck.life");
        this.appMap.put("com.adhub.app", "com.duorong.smarttool");
        this.appMap.put("com.jiaxiao", "com.jxedt");
        this.appMap.put("com.hiyrr", "com.martian.ttbookhd");
        this.appMap.put("com.eghtht", "com.mendon.riza");
        this.appMap.put("com.fefe", "com.lishun.flyfish");
        this.appMap.put("com.ytx.era", "com.itcode.reader");
        this.appMap.put("com.lehfef", "com.aliyun.iot.living");
        this.appMap.put("com.dc.lotol", "com.vodone.know");
        this.appMap.put("com.adhub", "com.snda.lantern.wifilocating");
        this.appMap.put("com.jo.avi", "com.sevenVideo.app.android");
        this.appMap.put("com.zhangshang", "com.ichano.athome.camera");
        this.appMap.put("com.jooa", "com.zlkj.cjszgj");
        this.appMap.put("com.yy", "com.duowan.mobile");
    }

    public PddRequest reqConvert(AdxCommonBidRequest commonReq, DspInfo dspInfo) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(this.dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();
        List<Imp> imps = impList.stream().map(imp -> this.impConvert((CommonImp)imp, dspInfo)).collect(Collectors.toList());
        if (imps.isEmpty() || imps.size() == 1 && imps.contains(null)) {
            return null;
        }
        pddRequest.setImp(imps);
        pddRequest.setSite(new Site());
        App app = this.appConvert(commonReq.getAppInfo());
        if (37526L == dspInfo.getIdeaId()) {
            this.replaceApp(app);
        }
        pddRequest.setApp(app);
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        if (Objects.isNull(userInfo)) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        device.setDevicetype(1);
        if (Objects.equals(commonDevice.getDeviceType(), 2)) {
            device.setDevicetype(2);
        }
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        if (StringUtils.isNotBlank((CharSequence)commonDevice.getOs())) {
            if ("0".equals(commonDevice.getOs())) {
                device.setOs("android");
            }
            if ("1".equals(commonDevice.getOs())) {
                device.setOs("ios");
            }
        }
        device.setOsv(commonDevice.getOsVersion());
        device.setCarrier(commonDevice.getCarrier());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            Caid caid = commonDevice.getCaids().get(0);
            device.setCaid(caid.getId());
        }
        device.setPaid(commonDevice.getPaid());
        device.setGeo(this.geoConvert(commonDevice.getGeo()));
        return device;
    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        if (Objects.isNull(commonGeo)) {
            return geo;
        }
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(Float.valueOf(lat.floatValue())));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(Float.valueOf(leo.floatValue())));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        app.setId(BlowfishUtils.encryptBlowfish((String)appInfo.getId()));
        app.setName(appInfo.getName());
        app.setBundle(appInfo.getBundle());
        app.setVersion(appInfo.getVersion());
        return app;
    }

    private void replaceApp(App app) {
        if (this.appMap.containsKey(app.getBundle())) {
            String bundle = this.appMap.get(app.getBundle());
            app.setBundle(bundle);
            app.setName(app.getId());
            return;
        }
        Random random = new Random();
        int i = random.nextInt(this.appMap.size());
        String budle = this.appMap.values().stream().skip(i).findFirst().get();
        app.setBundle(budle);
        app.setName(app.getId());
    }

    public Imp impConvert(CommonImp commonImp, DspInfo dspInfo) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return null;
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        if (StringUtils.isBlank((CharSequence)dspInfo.getDspTemplateId()) || StringUtils.isBlank((CharSequence)dspInfo.getDspTagId())) {
            LOGGER.warn("\u8ba1\u5212\u672a\u914d\u7f6edsp\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e \u8ba1\u5212id {}", (Object)dspInfo.getIdeaId());
            return null;
        }
        imp.setTagid(dspInfo.getDspTagId());
        templates.add(new Template(dspInfo.getDspTemplateId()));
        imp.setTemplates(templates);
        imp.setId(commonImp.getId());
        long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100.0)) + 1L;
        imp.setBidfloor((int)bidFloor);
        imp.setContent_type(Arrays.asList(1, 2));
        imp.setSupport_deeplink(commonImp.isOpenDeepLink());
        return imp;
    }
}

