/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.KuaishouDspProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidResponseOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.KuaishouDspRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.KuaishouDspResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class KuaishouDspInvoker
extends AbstractDspCaller<KuaishouBidResponseOuterClass.KuaishouBidResponse, KuaishouBidRequestOuterClass.KuaishouBidRequest> {
    private static final Logger log = LoggerFactory.getLogger(KuaishouDspInvoker.class);
    @Resource
    private KuaishouDspRequestConverter kuaishouDspRequestConverter;
    @Resource
    private KuaishouDspResponseConverter kuaishouDspResponseConverter;
    @Resource
    private KuaishouDspProperties kuaishouDspProperties;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected KuaishouBidResponseOuterClass.KuaishouBidResponse invokeDsp(KuaishouBidRequestOuterClass.KuaishouBidRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u5feb\u624bDSP\u8c03\u7528");
        try {
            return (KuaishouBidResponseOuterClass.KuaishouBidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.kuaishouDspProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"kuaishou");
        }
        catch (ResourceAccessException e) {
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            SamplerLog.warn((String)"\u5feb\u624b\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KuaishouBidResponseOuterClass.KuaishouBidResponse doHttpInvoke(String url, KuaishouBidRequestOuterClass.KuaishouBidRequest rtbRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf");
        HttpEntity requestEntity = new HttpEntity((Object)rtbRequest.toByteArray(), (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
        org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
        if (resource == null) {
            return null;
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        KuaishouBidResponseOuterClass.KuaishouBidResponse body = KuaishouBidResponseOuterClass.KuaishouBidResponse.parseFrom(resource.getInputStream());
        Transaction transaction = Cat.newTransaction((String)"invokeDSP", (String)"kuaishouReturn");
        transaction.setStatus("-1");
        try {
            if (statusCode.is2xxSuccessful()) {
                if (HttpStatus.OK.value() == statusCode.value()) {
                    Cat.logMetricForCount((String)"\u5feb\u624bDSP\u8fd4\u56de");
                    transaction.setStatus("0");
                    KuaishouBidResponseOuterClass.KuaishouBidResponse kuaishouBidResponse = body;
                    return kuaishouBidResponse;
                }
                SamplerLog.info((String)"\u5feb\u624bDSP\u65e0\u5185\u5bb9\u8fd4\u56de,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, body});
                Cat.logMetricForCount((String)"\u5feb\u624bDSP\u8fd4\u56de2xx");
                KuaishouBidResponseOuterClass.KuaishouBidResponse kuaishouBidResponse = null;
                return kuaishouBidResponse;
            }
            if (statusCode.is5xxServerError()) {
                Cat.logMetricForCount((String)"\u5feb\u624bDSP\u8fd4\u56de5xx");
                SamplerLog.info((String)"\u5feb\u624bDSP\u8fd4\u56de5xx,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, body});
                KuaishouBidResponseOuterClass.KuaishouBidResponse kuaishouBidResponse = null;
                return kuaishouBidResponse;
            }
            Cat.logMetricForCount((String)"\u5feb\u624bDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801");
            SamplerLog.info((String)"\u5feb\u624bDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, body});
            KuaishouBidResponseOuterClass.KuaishouBidResponse kuaishouBidResponse = null;
            return kuaishouBidResponse;
        }
        finally {
            transaction.complete();
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            String token = this.kuaishouDspProperties.getToken();
            byte[] raw = token.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec keySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, keySpec);
            byte[] encrypt = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])encrypt);
        }
        catch (Exception e) {
            log.warn("KuaishouDspInvoker \u4ef7\u683c\u52a0\u5bc6\u5931\u8d25");
            return null;
        }
    }

    @Override
    public AdxCommonBidResponse doBid(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        return super.doBid(commonBidRequest, dspInfo);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_8.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_8;
    }

    @Override
    public KuaishouBidRequestOuterClass.KuaishouBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.kuaishouDspRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(KuaishouBidResponseOuterClass.KuaishouBidResponse rtbResponse) throws DspException {
        try {
            return this.kuaishouDspResponseConverter.respConvert(rtbResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${WIN_PRICE}") && price != null) {
            url = url.replace("${WIN_PRICE}", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }
}

