/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TanxResponseConvert {
    private static final Logger log = LoggerFactory.getLogger(TanxResponseConvert.class);

    public AdxCommonBidResponse respConvert(TanxBiddingResponse.Response response) {
        if (response == null || CollectionUtils.isEmpty(response.getSeatList())) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_5.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response.getSeatList());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<TanxBiddingResponse.Response.Seat> seatList) {
        ArrayList commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        TanxBiddingResponse.Response.Seat seat = seatList.get(0);
        TanxBiddingResponse.Response.Seat.Ad ad = seat.getAd(0);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        ArrayList<CommonImage> imageList = null;
        CommonImage image2 = new CommonImage();
        ArrayList<CommonVideo> videoList = null;
        CommonVideo video = new CommonVideo();
        commonSeatBid.setPrice(Double.parseDouble(String.valueOf(ad.getBidPrice())));
        commonSeatBid.setAdvertiserId("46778");
        ArrayList<String> winCallbackUrls = new ArrayList<String>();
        winCallbackUrls.add(ad.getWinnoticeUrl());
        commonSeatBid.setWinCallbackUrls(winCallbackUrls);
        commonCreative.setLandingPageUrl(ad.getClickThroughUrl());
        commonCreative.setCreativeId(ad.getCreativeId());
        commonCreative.setDeepLinkUrl(ad.getDeeplinkUrl());
        context.setDeepLinkUrl(ad.getDeeplinkUrl());
        if (ad.getOpenType() == 4) {
            String clickThroughUrl = ad.getClickThroughUrl();
            context.setULinkUrl(clickThroughUrl);
        }
        ProtocolStringList impressionTrackingUrlList = ad.getImpressionTrackingUrlList();
        ArrayList<String> exposureUrls = new ArrayList<String>(impressionTrackingUrlList.size());
        exposureUrls.addAll((Collection<String>)impressionTrackingUrlList);
        commonSeatBid.setExposureCallbackUrls(exposureUrls);
        ProtocolStringList clickTrackingUrlList = ad.getClickTrackingUrlList();
        ArrayList<String> clickUrls = new ArrayList<String>(clickTrackingUrlList.size());
        clickUrls.addAll((Collection<String>)clickTrackingUrlList);
        commonSeatBid.setClickCallbackUrls(clickUrls);
        TanxBiddingResponse.Response.Seat.Ad.NativeAd nativeAd = ad.getNativeAd();
        List<TanxBiddingResponse.Response.Seat.Ad.NativeAd.Attr> attrList = nativeAd.getAttrList();
        for (TanxBiddingResponse.Response.Seat.Ad.NativeAd.Attr attr : attrList) {
            String name = attr.getName();
            String value = attr.getValue();
            if ("img_url".equals(name)) {
                image2.setUrl(value);
                video.setCoverUrl(value);
            }
            if ("img_width".equals(name)) {
                image2.setWidth(Integer.valueOf(value));
                video.setCoverWidth(Integer.valueOf(value));
            }
            if ("img_height".equals(name)) {
                image2.setHeight(Integer.valueOf(value));
                video.setCoverHeight(Integer.valueOf(value));
            }
            if ("video".equals(name)) {
                video.setVideoUrl(value);
            }
            if ("video_width".equals(name)) {
                video.setResolutionX(Integer.valueOf(value));
            }
            if ("video_height".equals(name)) {
                video.setResolutionY(Integer.valueOf(value));
            }
            if ("video_duration".equals(name)) {
                video.setDuration(new BigDecimal(value));
            }
            if (!"title".equals(name)) continue;
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(value);
            commonCreative.setCommonTitle(commonTitle);
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(value);
            commonCreative.setCommonDesc(commonDesc);
        }
        if (StringUtils.isNotBlank((CharSequence)video.getVideoUrl())) {
            videoList = new ArrayList<CommonVideo>();
            videoList.add(video);
            commonCreative.setCommonVideoList(videoList);
        } else {
            imageList = new ArrayList<CommonImage>();
            imageList.add(image2);
            commonCreative.setCommonImageList(imageList);
        }
        return commonSeatBidList;
    }
}

