package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.AdPosition;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Request;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

@Component
@Slf4j
public class RequestConvert {

    public Request convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Request request = new Request();
        App app = convertApp(adxCommonBidRequest);
        if (app == null) {
            return null;
        }
        request.setApp(app);
        AdPosition adPosition = convertAdPosition(adxCommonBidRequest, dspInfo);
        request.setAdPosition(adPosition);
        Device device = convertDevice(adxCommonBidRequest, dspInfo);
        request.setDevice(device);
        //0 http 1 https
        Integer httpProtocol = adxCommonBidRequest.getHttpProtocol();
        request.setHttpsRequired(false);
        if (Objects.equals(httpProtocol, 1)) {
            request.setHttpsRequired(true);
        }

        return request;
    }

    private Device convertDevice(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        if (commonDevice == null) {
            return null;
        }
        Device device = new Device();
        String os = commonDevice.getOs();
        if (StringUtils.isNotBlank(os)) {
            if ("0".equals(commonDevice.getOs())) {
                device.setOs(1);
            }
            if ("1".equals(commonDevice.getOs())) {
                device.setOs(2);
            }
        }
        device.setIp(commonDevice.getIp());
        device.setUserAgent(commonDevice.getUa());
        device.setOsVersion(commonDevice.getOsVersion());
        device.setVendor(commonDevice.getMake());
        device.setMac(commonDevice.getMac());
        device.setMacMd5(commonDevice.getMacMd5());
        device.setOaid(commonDevice.getOaId());
        device.setMd5Oaid(commonDevice.getOaIdMd5());
        device.setImei(commonDevice.getImei());
        device.setMd5Imei(commonDevice.getImeiMd5());
        List<Caid> caids = commonDevice.getCaids();
        if (CollectionUtils.isNotEmpty(caids)) {
            Caid caid = caids.get(0);
            device.setCaid(caid.getId());
            device.setCaidVer(caid.getVersion());
        }
        device.setIdfa(commonDevice.getIdFa());
        device.setMd5Idfa(commonDevice.getIdFaMd5());
        device.setModelNo(commonDevice.getModel());
        device.setOsBootMark(commonDevice.getBootTime());
        device.setOsUpdateMark(commonDevice.getUpdateTime());
        device.setDeviceBirthTime(commonDevice.getBirthTime());
        device.setPaId(commonDevice.getPaid());
        return device;
    }

    private AdPosition convertAdPosition(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        AdPosition adPosition = new AdPosition();
        adPosition.setAdPositionId(dspInfo.getDspTagId());
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        CommonSizeInfo sizeInfo = commonImp.getFilteringSize().get(0);
        adPosition.setAdWidth(sizeInfo.getWidth());
        adPosition.setAdHeight(sizeInfo.getHeight());
        return adPosition;
    }

    private App convertApp(AdxCommonBidRequest adxCommonBidRequest) {
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        if (appInfo == null) {
            return null;
        }
        App app = new App();
        //todo 使用一个固定的appId
//        app.setAppId();
        app.setPackageName(appInfo.getBundle());
        app.setAppVersion(appInfo.getVersion());
        return app;
    }
}
