package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Ad;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Response;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Component
@Slf4j
public class ResponseConvert {
    public AdxCommonBidResponse convert(Response response) {
        if (response == null) {
            return null;
        }
        if (response.getCode() == null || response.getCode() != 200) {
            return null;
        }

        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setDspId(DspEnum.DSP_9.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response);
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(Response response) {
        Ad data = response.getData();
        List<CommonSeatBid> commonSeatBids = new ArrayList<>();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext commonContext = new CommonContext();
        commonSeatBid.setCommonContext(commonContext);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        //0 未知 1开屏 2插屏 3横幅 4单图信息流 5多图信息流 6视频
        Integer materialType = data.getMaterialType();
        String title = data.getTitle();
        if (StringUtils.isNotBlank(title)) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(title);
            commonCreative.setCommonTitle(commonTitle);
        }
        String desc = data.getDesc();
        if (StringUtils.isNotBlank(desc)) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(desc);
            commonCreative.setCommonDesc(commonDesc);
        }
        List<CommonImage> imageList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(data.getImageUrlList())) {
            List<String> imageUrlList = data.getImageUrlList();
            for (String s : imageUrlList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(s);
                imageList.add(commonImage);
            }
            commonCreative.setCommonImageList(imageList);
        }
        if (StringUtils.isNotBlank(data.getImageUrl())) {
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(data.getImageUrl());
            imageList.add(commonImage);
            commonCreative.setCommonImageList(imageList);
        }
        if (data.getVideo() != null) {
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(data.getVideo().getUrl());
            commonVideo.setDuration(BigDecimal.valueOf(data.getVideo().getDuration()));
            List<CommonVideo> commonVideoList = new ArrayList<>();
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        }
        if (Objects.equals(data.getDeeplinkType(), 0)) {
            commonContext.setDeepLinkUrl(data.getDeeplinkUrl());
        }
        if (Objects.equals(data.getDeeplinkType(), 1)) {
            commonContext.setULinkUrl(data.getDeeplinkUrl());
        }


        commonSeatBids.add(commonSeatBid);
        return commonSeatBids;
    }
}
