package cn.com.duiba.tuia.dsp.engine.api.dsp.admobile;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Request;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.bean.Response;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert.RequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.convert.ResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.DSP_HTTP_INVOKE_FAILED;
import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.DSP_INVOKE_FAILED;

/**
 * @author wangwei
 */
@Slf4j
@Component
public class AdMobileDspInvoker extends AbstractDspCaller<Response, Request> {
    @Autowired
    private AdMobileProperties adMobileProperties;
    @Autowired
    private RequestConvert requestConvert;
    @Autowired
    private ResponseConvert responseConvert;


    @Override
    protected Response invokeDsp(Request request) {
        if (request == null) {
            return null;
        }
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(adMobileProperties.getUrl(), request), "invokeDSP", "AdMobile");
        } catch (ResourceAccessException e) {
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            SamplerLog.warn("AdMobileDSP调用异常", e);
            return null;
        }
    }

    private Response doHttpInvoke(String url, Request request) {

        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("0276af914fee82a4".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            String s = Base64.getEncoder().encodeToString(bytes);
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        } catch (Exception e) {
            log.warn("AdMobile加密失败 ", e);
        }
        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_9.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_9;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__TM_BID_PRICE__") && price != null) {
            url = url.replaceAll("__TM_BID_PRICE__", price);
        }
        return url;
    }

    @Override
    public Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return requestConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(Response response) throws DspException {
        return responseConvert.convert(response);
    }
}
