package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter.MoYiRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter.MoYiResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

@Slf4j
@Component
public class MoYiDspInvoker extends AbstractDspCaller<MoYiBidResponse, MoYiBidRequest> {

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Autowired
    private MoYiRequestConvert moYiRequestConvert;
    @Autowired
    private MoYiResponseConvert moYiResponseConvert;
    @Autowired
    private MoYiProperties moYiProperties;

    @Override
    protected MoYiBidResponse invokeDsp(MoYiBidRequest tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        Cat.logMetricForCount("沫易DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(moYiProperties.getUrl(), tanxBiddingRequest), "invokeDSP", "moyi");
        } catch (ResourceAccessException e) {
            log.warn("沫易 DSP,http请求异常,{}", e.getMessage());
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            log.error("沫易 DSP请求失败,{}", e.getMessage());
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            log.error("沫易其他调用异常", e);
            return null;
        }
    }

    private MoYiBidResponse doHttpInvoke(String url, MoYiBidRequest request) throws IOException {

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<MoYiBidRequest> requestEntity = new HttpEntity<>(request, headers);
        ResponseEntity<MoYiBidResponse> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, MoYiBidResponse.class);
        HttpStatus statusCode = resEntity.getStatusCode();
        MoYiBidResponse body = resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            } else {
                SamplerLog.info("沫易DSP无内容返回,statusCode:[{}],request[{}],body[{}]",statusCode.value(), JSONObject.toJSONString(request), JSONObject.toJSONString(body));
                return null;
            }
        } else if (statusCode.is5xxServerError()) {
            log.warn("沫易DSP返回5xx,statusCode:[{}],request[{}],body[{}]",statusCode.value(), JSONObject.toJSONString(request), JSONObject.toJSONString(body));
            return null;
        } else {
            log.warn("沫易DSP返回其他状态码,statusCode:[{}],request[{}],body[{}]",statusCode.value(), JSONObject.toJSONString(request), JSONObject.toJSONString(body));
            return null;
        }
    }

    private MoYiBidResponse handle2xx(MoYiBidResponse response) {
        if(Objects.isNull(response)){
            return response;
        }
        if(CollectionUtils.isNotEmpty(response.getSeatBids())){
            Cat.logMetricForCount("沫易DSP返回");
        }
        return response;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        if(Objects.isNull(price)){
            return null;
        }
        String tme = price.toString();
        try {
            byte[] bytes1 = new byte[16];
            if (tme.length() == 16) {
                bytes1 = tme.getBytes(StandardCharsets.UTF_8);
            }
            if (tme.length() < 16 && tme.length() > 0) {
                byte[] bytes = tme.getBytes(StandardCharsets.UTF_8);
                int length = bytes.length;
                byte[] data2 = new byte[16 - length];
                ByteBuffer buffer = ByteBuffer.allocate(bytes.length + data2.length);
                buffer.put(bytes);
                buffer.put(data2);
                bytes1=buffer.array();
            }

            SecretKeySpec secretKey = new SecretKeySpec("gnnee3j8tpj65ogu".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] bytes = cipher.doFinal(bytes1);
            return Hex.toHexString(bytes);
        } catch (Exception e) {
            log.warn("沫易加密失败 ", e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception{

        String tme = "100";
        byte[] bytes1 = new byte[16];
        if (tme.length() == 16) {
            bytes1 = tme.getBytes(StandardCharsets.UTF_8);
        }
        if (tme.length() < 16 && tme.length() > 0) {
            byte[] bytes = tme.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            byte[] data2 = new byte[16 - length];
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + data2.length);
            buffer.put(bytes);
            buffer.put(data2);
            bytes1=buffer.array();
        }

        SecretKeySpec secretKey = new SecretKeySpec("rrtqgxt8jvanqu5isjcji3giqufegjkx".getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(Cipher.ENCRYPT_MODE, secretKey);
        byte[] bytes = cipher.doFinal(bytes1);
        System.out.println(Hex.toHexString(bytes));
    }


    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_7.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_7;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__PRICE__") && price != null) {
            url = url.replaceAll("__PRICE__", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public MoYiBidRequest convertReq(AdxCommonBidRequest request, DspInfo dspInfo) throws DspException {
        try {
            return moYiRequestConvert.reqConvert(request, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(MoYiBidResponse response) throws DspException {
        try {
            return moYiResponseConvert.respConvert(response);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}
