package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppConvert {
    @Autowired
    private ApolloPanGuService apolloPanGuService;

    public TanxBiddingRequest.Request.App convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        TanxBiddingRequest.Request.App.Builder builder = TanxBiddingRequest.Request.App.newBuilder();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        String ideaId = String.valueOf(dspInfo.getIdeaId());
        String jsonStr = apolloPanGuService.getIdMapStrByKeyStrResourceId("adx.dsp.replaceApp", ideaId);
        if (StringUtils.isNotBlank(jsonStr)) {
            JSONObject jsonObject = JSON.parseObject(jsonStr);
            String bundle = jsonObject.getString("bundle");
            String name = jsonObject.getString("name");
            builder.setPackageName(bundle);
            builder.setAppName(name);
        } else {
            if (StringUtils.isNotBlank(appInfo.getBundle())) {
                builder.setPackageName(appInfo.getBundle());
            }
            if (StringUtils.isNotBlank(appInfo.getName())) {
                builder.setAppName(appInfo.getName());
            }

        }
        builder.addCategory("102401");
        return builder.build();
    }
}
