package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class TanxRequestConvert {
    @Autowired
    private AppConvert appConvert;

    public TanxBiddingRequest.Request reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        TanxBiddingRequest.Request.Builder builder = TanxBiddingRequest.Request.newBuilder();
        builder.setVersion(2);
        builder.setId(adxCommonBidRequest.getRequestId());
        TanxBiddingRequest.Request.Impression imp = ImpConvert.convertImp(adxCommonBidRequest, dspInfo);
        builder.addImp(imp);
        TanxBiddingRequest.Request.App app = appConvert.convertApp(adxCommonBidRequest, dspInfo);
        builder.setApp(app);
        TanxBiddingRequest.Request.Device device = DeviceConvert.convertDevice(adxCommonBidRequest);
        builder.setDevice(device);
        return builder.build();
    }
}
