package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.tuia.advert.adxService.AdxEngineService;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @Author yuquanfeng
 * @Date 2022/11/28
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class BudgetConditionFilter implements AdvertConditionFilter {

    @Resource
    private AdxEngineService adxEngineService;

    AsyncLoadingCache<Long, Boolean> budgetValidCache = Caffeine.newBuilder()
            .refreshAfterWrite(1, TimeUnit.SECONDS)
            .buildAsync(this::load);

    public boolean load(Long key) {
        try {
            return adxEngineService.outDspBudgetValidInfo(key);
        } catch (Exception e) {
            //ignore
        }
        return false;
    }

    @Override
    public boolean match(DspInfo dspInfo) {
        Long advertId = dspInfo.getAdvertId();
        if (Objects.isNull(advertId)) {
            SamplerLog.info("BudgetConditionFilter.match advertId is null");
            return false;
        }
        try {
            Boolean validate = budgetValidCache.get(advertId).getNow(false);
            if (!validate) {
                SamplerLog.info("BudgetConditionFilter 广告已经失效advertId:{}", advertId);
            }
            return validate;
        } catch (Exception e) {
            SamplerLog.warn("BudgetConditionFilter error, dspInfo:{}", JSON.toJSONString(dspInfo), e);
            return false;
        }
    }
}
