package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;

/**
 * @author lizhiheng
 */
public interface DspAdapter<DspResp> {

    /**
     * 竞价流程
     *
     * @param adxCommonBidRequest
     */
    AdxCommonBidResponse doBid(AdxCommonBidRequest adxCommonBidRequest,DspInfo dspInfo);

    /**
     * 转换请求体
     *
     * @param adxCommonBidRequest
     * @param <DspReq>
     * @return
     * @throws DspException
     */
    <DspReq> DspReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException;


    /**
     * 转换返回体
     *
     * @param dspResp
     * @return
     * @throws DspException
     */
    AdxCommonBidResponse convertResp(DspResp dspResp) throws DspException;
}
