package cn.com.duiba.tuia.dsp.engine.api.util;

import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangBidding;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class QIHangTest {
    public static void main(String[] args) throws IOException {
        HttpClient httpClient = HttpClientBuilder.create().setMaxConnTotal(100)
                .setMaxConnPerRoute(200)
                .evictIdleConnections(5000, TimeUnit.MILLISECONDS).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(httpClient);
        factory.setConnectTimeout(500);
        factory.setReadTimeout(500);
        factory.setConnectionRequestTimeout(500);
        RestTemplate restTemplate = new RestTemplate(factory);
        List<HttpMessageConverter<?>> messageConverters = restTemplate.getMessageConverters();
        for (HttpMessageConverter c : messageConverters) {
            if (c instanceof StringHttpMessageConverter) {
                ((StringHttpMessageConverter) c).setDefaultCharset(StandardCharsets.UTF_8);
            }
        }
        String json = "{\"api_version\":\"1.0.0\",\"app\":{\"bundle\":\"com.happyelements.AndroidAnimal.ad\",\"name\":\"开心消消乐android_he_share\"},\"device\":{\"carrier\":0,\"connection_type\":2,\"device_type\":4,\"ip\":\"117.182.141.189\",\"make\":\"HUAWEI\",\"model\":\"SEA-AL10\",\"oaid\":\"ead32b65-feec-2331-feff-bcffffed5a4a\",\"oaid_md5\":\"1b38f87382e409abe4e3ef40dce2da30\",\"os\":\"android\",\"osv\":\"10.0.0\",\"ua\":\"Mozilla/5.0 (Linux; Android 10; SEA-AL10 Build/HUAWEISEA-AL10; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/92.0.4515.105 Mobile Safari/537.36\"},\"id\":\"d0d88274-edce-11ee-a27c-00163e35116f\",\"imp\":{\"ad_type\":4,\"asset\":[{\"height\":1280,\"template_id\":\"1_1\",\"width\":720}],\"bid_floor\":3000,\"bid_type\":0,\"id\":\"1\",\"tag_id\":\"40013\"},\"ssp_time\":1711718301835,\"test\":0}";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<String> requestEntity = new HttpEntity<>(json, headers);

        String url = "https://rtb.julang.taobao.com/dsp/surge/bidding/ADX_TUIA";
//        String url = "https://pre-rtb-1.julang.taobao.com/dsp/surge/bidding/ADX_TUIA";
        ResponseEntity<Resource> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
        InputStream inputStream = resEntity.getBody().getInputStream();
        QiHangBidding.BidResponse bidResponse = QiHangBidding.BidResponse.parseFrom(inputStream);
        System.out.println(bidResponse);
    }
}
