package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert.QiHangJsonReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert.QiHangJsonRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangResp;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;

@Slf4j
@Component
public class QiHangDspInvoker extends AbstractDspCaller<QiHangResp, QiHangReq> {
    @Autowired
    private QiHangJsonReqConvert qiHangJsonReqConvert;
    @Autowired
    private QiHangJsonRespConvert qiHangJsonRespConvert;
//    @Autowired
//    private QiHangRespConvert qiHangRespConvert;
    @Autowired
    private QiHandProperties qiHandProperties;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected QiHangResp invokeDsp(QiHangReq bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount("启航DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(qiHandProperties.getUrl(), bidRequest), "invokeDSP", "qihang");
        } catch (Throwable t) {
            log.warn("启航调用异常", t);
        }
        return null;
    }

    private QiHangResp doHttpInvoke(String url, QiHangReq bidRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<QiHangReq> requestEntity = new HttpEntity<>(bidRequest, headers);
        ResponseEntity<QiHangResp> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, QiHangResp.class);
        QiHangResp body = resEntity.getBody();
        if (body == null) {
            return null;
        }
        SamplerLog.info("启航 返回 {}", body);
        if (CollectionUtils.isEmpty(body.getSeat_bid())) {
            return null;
        }
        Cat.logMetricForCount("启航DSP返回");
        return body;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("BzABOvVhLYJiuo3Y".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            //2进制转换成16进制
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex);
            }
            return sb.toString();
        } catch (Exception e) {
            log.warn("启航加密失败 ", e);
        }
        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_10.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_10;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public QiHangReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return qiHangJsonReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(QiHangResp bidResponse) throws DspException {
        return qiHangJsonRespConvert.convert(bidResponse);
    }
}
