package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

@Slf4j
@Component
public class TanxDspInvoker extends AbstractDspCaller<TanxBiddingResponse.Response, TanxBiddingRequest.Request> {

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Autowired
    private TanxRequestConvert tanxRequestConvert;
    @Autowired
    private TanxResponseConvert tanxResponseConvert;
    @Autowired
    private TanxProperties tanxProperties;

    @Override
    protected TanxBiddingResponse.Response invokeDsp(TanxBiddingRequest.Request tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(tanxProperties.getUrl(), tanxBiddingRequest), "invokeDSP", "tanx");
        } catch (ResourceAccessException e) {
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            SamplerLog.warn("tanxDSP调用异常", e);
            return null;
        }
    }

    private TanxBiddingResponse.Response doHttpInvoke(String url, TanxBiddingRequest.Request tanxBiddingRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        HttpEntity<byte[]> requestEntity = new HttpEntity<>(tanxBiddingRequest.toByteArray(), headers);
        SamplerLog.info("tanx doHttpInvoke rtbRequest:{}", tanxBiddingRequest);
        Cat.logMetricForCount("tanxDSP调用");
        ResponseEntity<org.springframework.core.io.Resource> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
        org.springframework.core.io.Resource resource = resEntity.getBody();
        if (resource == null) {
            return null;
        }
        TanxBiddingResponse.Response response = TanxBiddingResponse.Response.parseFrom(resource.getInputStream());
        if (CollectionUtils.isNotEmpty(response.getSeatList())) {
            Cat.logMetricForCount("tanxDSP返回");
        }
        return response;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("f06a2467e1669643".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(bytes);
        } catch (Exception e) {
            log.warn("tanx加密失败 ", e);
        }
        return null;
    }

    public static void main(String[] args) {
        TanxDspInvoker invoker = new TanxDspInvoker();
        String s = invoker.priceEncryption(new BigDecimal("10"));
        System.out.println(s);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_5.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_5;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%SETTLE_PRICE%%") && price != null) {
            url = url.replaceAll("%%SETTLE_PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public TanxBiddingRequest.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return tanxRequestConvert.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(TanxBiddingResponse.Response tanxBiddingResponse) throws DspException {
        try {
            return tanxResponseConvert.respConvert(tanxBiddingResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}
