/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.FilterMaterInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.CarrierConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.ConnectionTypeConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.DeviceTypeConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.OsConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter.OsvConverter;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import cn.com.duiba.tuia.dsp.engine.api.util.UAUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KuaishouDspRequestConverter {
    private static final Logger log = LoggerFactory.getLogger(KuaishouDspRequestConverter.class);
    @Autowired
    private AppReplace appReplace;

    public KuaishouBidRequestOuterClass.KuaishouBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Builder builder = KuaishouBidRequestOuterClass.KuaishouBidRequest.newBuilder();
        builder.addImpressions(this.convertImp(adxCommonBidRequest, dspInfo));
        builder.setId(adxCommonBidRequest.getRequestId());
        builder.setDevice(this.convertDevice(adxCommonBidRequest.getDevice(), adxCommonBidRequest.getAdxType()));
        builder.setIp(this.optionOfNull(adxCommonBidRequest.getDevice().getIp()));
        builder.setGeo(this.convertGeo(adxCommonBidRequest.getDevice().getGeo()));
        builder.setApp(this.convertApp(adxCommonBidRequest.getAppInfo(), dspInfo));
        return builder.build();
    }

    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Device convertDevice(CommonDevice device, Integer adxType) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Device.Builder deviceBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Device.newBuilder();
        if (Objects.isNull(device)) {
            return deviceBuilder.build();
        }
        deviceBuilder.setDeviceType(DeviceTypeConverter.getDeviceType(device.getUa()));
        UAData uaData = UAUtils.parseUA(device.getUa());
        deviceBuilder.setOs(OsConverter.getOsType(device.getOs(), uaData));
        deviceBuilder.setOsVersion(OsvConverter.getOsvType(device.getUa()));
        deviceBuilder.setUserAgent(this.optionOfNull(device.getUa()));
        deviceBuilder.setCarrier(CarrierConverter.getCarrierType(device.getCarrier()));
        deviceBuilder.setConnectionType(ConnectionTypeConverter.getConnectionType(device.getTuiaConnectionType()));
        deviceBuilder.setBrandAndModel(this.getModel(device.getMake(), uaData));
        deviceBuilder.setIdfa(this.optionOfNull(device.getIdFa()));
        deviceBuilder.setIdfaMd5(this.optionOfNull(device.getIdFaMd5()));
        deviceBuilder.setManufacturer(this.getMaker(device.getMake(), uaData));
        deviceBuilder.setOaid(this.optionOfNull(device.getOaId()));
        deviceBuilder.setOaidMd5(this.optionOfNull(device.getOaIdMd5()));
        deviceBuilder.setImei(this.optionOfNull(device.getImei()));
        deviceBuilder.setImeiMd5(this.optionOfNull(device.getImeiMd5()));
        return deviceBuilder.build();
    }

    private String getModel(String model, UAData uaData) {
        String model1;
        if (StringUtils.isNotBlank((CharSequence)model)) {
            return model;
        }
        if (Objects.nonNull(uaData) && StringUtils.isNotBlank((CharSequence)(model1 = uaData.getModel()))) {
            return model1;
        }
        return " ";
    }

    private String getMaker(String make, UAData uaData) {
        if (StringUtils.isNotBlank((CharSequence)make)) {
            return make;
        }
        if (Objects.nonNull(uaData)) {
            if (Objects.equals("Android", uaData.getOsType())) {
                return "huawei";
            }
            return "apple";
        }
        return "unknow";
    }

    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo convertGeo(CommonGeo geo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo.Builder geoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo.newBuilder();
        if (Objects.isNull(geo)) {
            return geoBuilder.build();
        }
        Optional.ofNullable(geo.getLat()).ifPresent(lat -> geoBuilder.setLatitude(lat.intValue()));
        Optional.ofNullable(geo.getLon()).ifPresent(leo -> geoBuilder.setLongitude(leo.intValue()));
        return geoBuilder.build();
    }

    private KuaishouBidRequestOuterClass.KuaishouBidRequest.App convertApp(CommonAppInfo appInfo, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.App.Builder appInfoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.App.newBuilder();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            String bundle = replaceApp.getBundle();
            appInfoBuilder.setAppBundleId(bundle);
        } else if (Objects.nonNull(appInfo)) {
            appInfoBuilder.setAppBundleId(appInfo.getBundle());
        } else {
            appInfoBuilder.setAppBundleId("com.tuia");
        }
        return appInfoBuilder.build();
    }

    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression.Builder impInfoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression.newBuilder();
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) {
            return impInfoBuilder.build();
        }
        CommonImp commonImp = impList.get(0);
        impInfoBuilder.setId(this.optionOfNull(commonImp.getId()));
        List<CommonSizeInfo> filteringSize = this.filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());
        if (CollectionUtils.isNotEmpty(filteringSize)) {
            ArrayList templateIds = Lists.newArrayList();
            if (dspInfo.getDspTagId() != null) {
                impInfoBuilder.setPlacementId(dspInfo.getDspTagId());
            }
            if (dspInfo.getDspTemplateId() != null) {
                templateIds.add(Long.valueOf(dspInfo.getDspTemplateId()));
            }
            impInfoBuilder.addAllTemplateIds(templateIds);
            long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100.0)) + 1L;
            impInfoBuilder.setCpmBidFloor(bidFloor);
            String dspResId = dspInfo.getDspResId();
            if (StringUtils.isNumeric((CharSequence)dspResId)) {
                impInfoBuilder.setPlacementType(Integer.parseInt(dspResId));
            }
            impInfoBuilder.addSupportCostTypes(KuaishouBidRequestOuterClass.CostType.COSTTYPE_CPM);
            impInfoBuilder.setAdsCount(1);
            impInfoBuilder.setSupportDeepLink(commonImp.isOpenDeepLink());
            if (CollectionUtils.isEmpty(impInfoBuilder.getTemplateIdsList())) {
                log.warn("\u672a\u627e\u5230\u5bf9\u5e94\u5149\u544a\u5e7f\u544a\u4f4d\uff0ccommonImp {}", (Object)JSON.toJSONString((Object)commonImp));
                return impInfoBuilder.build();
            }
        }
        impInfoBuilder.setId(commonImp.getId());
        return impInfoBuilder.build();
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        ArrayList commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = this.matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (!Objects.nonNull(commonSizeInfo1)) continue;
            commonSizeInfos.add(commonSizeInfo1);
        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (!filterMaterInfo.getWidth().equals(width) || !filterMaterInfo.getHeight().equals(height)) continue;
            return commonSizeInfo;
        }
        return null;
    }

    private String optionOfNull(String param) {
        return Optional.ofNullable(param).orElse("");
    }
}

