/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.constants.PddNbr;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddReqConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddRespConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
@EnableConfigurationProperties(value={PddProperties.class})
public class PddDspInvoker
extends AbstractDspCaller<PddResponse, PddRequest> {
    public static final String jsonStr = "{\n    \"adx_id\":\"mrk_union_imb\",\n    \"request_id\":\"1\",\n    \"bid_id\":\"f79103137bb04105bc74ccac5101401c\",\n    \"seatbid\":[\n        {\n            \"bid\":[\n                {\n                    \"id\":\"f79103137bb04105bc74ccac5101401c_0\",\n                    \"impid\":\"1_1\",\n                    \"tagid\":\"\",\n                    \"template_id\":\"1.4.1\",\n                    \"price\":60000,\n                    \"pdd_adid\":\"100157114726\",\n                    \"nurl\":\"https://t-dsp.pinduoduo.com/dspcb/w/mrk_union?acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb_aff_splsh&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&st0=-1&st1=2&goods_id=&price_st=-1&lx=1&lxt=99&bundle=com.filemagic&did=8356c484baee55db3144931bd2b3bfc6&price=%%PRICE%%&os=android&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&display_id=151&source=3&y19=54091&sub_channel=mrk_union_imb\",\n                    \"iurl\":[\n                        \"https://t-dsp.pinduoduo.com/dspcb/i/mrk_union?pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb_aff_splsh&os=android&did=8356c484baee55db3144931bd2b3bfc6&acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&st0=-1&st1=2&price_st=-1&lx=1&lxt=99&goods_id=&bundle=com.filemagic&price=%%PRICE%%&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&v_cat=-2&display_id=151&source=3&pctr=0.00000&y19=54091&sub_channel=mrk_union_imb\"\n                    ],\n                    \"curl\":[\n                        \"https://at.pinduoduo.com/a/mrk_union?acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&launch_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb10/21\u5a92\u4f53\u5e7f\u544a\u5e73\u53f0\u63a5\u5165\u62fc\u591a\u591a\u5916\u6295\u5e7f\u544a\u6280\u672f\u89c4\u8303_aff_splsh&os=android&did=8356c484baee55db3144931bd2b3bfc6&goods_id=&st0=-1&st1=2&lx=1&lxt=99&price_st=-1&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&bundle=com.filemagic&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&v_cat=-2&display_id=151&source=3&pcvr=0.00000&sub_channel=mrk_union_imb&imei=8356c484baee55db3144931bd2b3bfc6&oaid=8356c484baee55db3144931bd2b3bfc6&y19=54091\",\n                        \"https://t-dsp.pinduoduo.com/dspcb/c/mrk_union?acc=100001&ads_set=10000495&ads_id=1000011693&creative_id=100157114726&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0&launch_id=f79103137bb04105bc74ccac5101401c_0&ads_csite=imb_aff_splsh&os=android&did=8356c484baee55db3144931bd2b3bfc6&goods_id=&st0=-1&st1=2&lx=1&lxt=99&price_st=-1&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&bundle=com.filemagic&soid=56c4210acf37915fc10100004e0300006e42a0ff&cate1_id=0&v_cat=-2&display_id=151&source=3&pcvr=0.00000&sub_channel=mrk_union_imb&imei=8356c484baee55db3144931bd2b3bfc6&oaid=8356c484baee55db3144931bd2b3bfc6&y19=54091\"\n                    ],\n                    \"click_url\":\"https://lp.pinduoduo.com/poros/h5?vst_scene=pdv&acc=100001&soid=56c4210acf37915fc10100004e0300006e42a0ff&ads_channel=mrk_union&display_id=151&source=3&lx=1&creative_id=100157114726&ads_csite=imb_aff_splsh&price_st=-1&cate1_id=0&bundle=com.filemagic&page_uid=909ded3c60174bf093868b4658b58fe1&ut=YTgwMzFkZTAtOTJhNi00M4L1xNgPzjFP__Ik7A==&y19=54091&os=android&src=mrk_union&abs_id=104629&lxt=99&st0=-1&st2=8356c484baee55db3144931bd2b3bfc6&ads_set=10000495&st1=2&st3=8356c484baee55db3144931bd2b3bfc6&ads_id=1000011693&pdd_bid_id=f79103137bb04105bc74ccac5101401c_0\",\n                    \"content_type\":1,\n                    \"deeplink_url\":\"pddopen://pinduoduo?h5Url=mlp_land_nd.html%3F_p_acc%3D100001%26_p_source%3D3%26y19%3D54091%26_p_ads_set%3D10000495%26_p_launch_id%3Df79103137bb04105bc74ccac5101401c_0%26_p_cate1_id%3D0%26_p_ads_id%3D1000011693%26is_lego%3D1%26_p_launch_type%3Ddsp%26_p_creative_id%3D100157114726%26lego_url%3Dhttps%253A%252F%252Ft16img.yangkeduo.com%252Flego-bundle%252Flego%252Fad_land_20190820_161047_2_1_3.lego%253FpageName%253Dad_land%26jump_url%3Dmkt_daily999.html%26_p_pdd_bid_id%3Df79103137bb04105bc74ccac5101401c_0%26_p_display_id%3D151%26_oc_ads_channel%3Dmrk_union%26_p_soid%3D56c4210acf37915fc10100004e0300006e42a0ff%26_p_ads_channel%3Dmrk_union%26_p_ads_csite%3Dimb_aff_splsh%26lego_minversion%3D4.58.0&direct_back=true\",\n                    \"app_name\":\"\\u62FC\\u591A\\u591A\",\n                    \"app_bundle\":\"com.xunmeng.pinduoduo\",\n                    \"adm\":{\n                        \"title\":\"X\\u5927\\u989D\\u7EA2\\u5305\\uFF0C\\u7B49\\u4F60\\u6765\\u9886\",\n                        \"image_url\":[\n                            \"http://images.pinduoduo.com/marketing_api/2020-10-22/3a9c9023-ad82-477a-bb7e-1bd75321d4ab.jpeg\"\n                        ]\n                    }\n                }\n            ],\n            \"seat\":\"pinduoduo\"\n        }\n    ],\n    \"nbr\":0\n}";
    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddReqConverter pddConverter;
    @Resource
    PddRespConverter pddRespConverter;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Resource
    private PddProperties pddProperties;

    @Override
    public PddRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.pddConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    protected PddResponse invokeDsp(PddRequest pddRequest) {
        if (pddRequest == null) {
            return null;
        }
        if (pddRequest.getImp() == null || pddRequest.getImp().isEmpty()) {
            return null;
        }
        Cat.logMetricForCount((String)"\u62fc\u591a\u591aDSP\u8c03\u7528");
        try {
            return (PddResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.pddProperties.getUrl(), pddRequest), (String)"invokeDSP", (String)"pdd");
        }
        catch (ResourceAccessException e) {
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            LOGGER.error("\u62fc\u591a\u591a\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", e);
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(this.pddProperties.getAdxSecret().getBytes(), "AES"));
            return new String(Base64.getEncoder().encode(cipher.doFinal(price.toString().getBytes())));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.warn("{}\u4ef7\u683c\u89e3\u5bc6\u5931\u8d25,secret:{}", new Object[]{this.pddProperties.getAdxId(), this.pddProperties.getAdxSecret(), e});
            return null;
        }
    }

    private PddResponse doHttpInvoke(String url, PddRequest pddRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)pddRequest, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, PddResponse.class, new Object[0]);
        HttpStatus statusCode = resEntity.getStatusCode();
        PddResponse body = (PddResponse)resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            }
            if (SamplerLog.infoFlag()) {
                SamplerLog.info((String)"\u62fc\u591a\u591aDSP\u65e0\u5185\u5bb9\u8fd4\u56de,pddRequest[{}],body[{}]", (Object[])new Object[]{JSONObject.toJSONString((Object)pddRequest), JSONObject.toJSONString((Object)body)});
            }
            return null;
        }
        if (statusCode.is5xxServerError()) {
            LOGGER.warn("\u62fc\u591a\u591aDSP\u8fd4\u56de5xx,pddRequest[{}],body[{}]", (Object)JSONObject.toJSONString((Object)pddRequest), (Object)JSONObject.toJSONString((Object)body));
            return null;
        }
        LOGGER.warn("\u62fc\u591a\u591aDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,pddRequest[{}],body[{}]", (Object)JSONObject.toJSONString((Object)pddRequest), (Object)JSONObject.toJSONString((Object)body));
        return null;
    }

    private PddResponse handle2xx(PddResponse pddResponse) {
        Integer val;
        if (!pddResponse.getNbr().equals(0) && SamplerLog.infoFlag()) {
            SamplerLog.info((String)"\u62fc\u591a\u591aDSP\u8fd4\u56de\u4e3a\u7a7a:{}", (Object[])new Object[]{JSONObject.toJSONString((Object)pddResponse)});
        }
        if (Objects.isNull(val = pddResponse.getNbr())) {
            return null;
        }
        if (PddNbr.NBR_0.getNbr().equals(val)) {
            Cat.logMetricForCount((String)"\u62fc\u591a\u591aDSP\u8fd4\u56de");
        }
        return pddResponse;
    }

    @Override
    public AdxCommonBidResponse convertResp(PddResponse pddResponse) throws DspException {
        try {
            return this.pddRespConverter.respConvert(pddResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_3.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_3;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            url = url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }
}

