/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.RuiShiProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Bid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.RuiShiReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.RuiShiRsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert.RuiShiReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert.RuiShiRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.google.doubleclick.crypto.DoubleClickCrypto;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import javax.annotation.Resource;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class RuiShiDspInvoker
extends AbstractDspCaller<RuiShiRsp, RuiShiReq> {
    private static final Logger log = LoggerFactory.getLogger(RuiShiDspInvoker.class);
    public static DoubleClickCrypto.Price clickCrypto = null;
    public static final byte[] KEY1 = "b8459ad37b619125b7125026d8005f5a".getBytes();
    public static final byte[] KEY2 = "77c589c81cd026c8170bbf7c1a16c857".getBytes();
    public static final BigDecimal ONEHUNDRED = new BigDecimal(100);
    @Autowired
    private RuiShiReqConvert reqConvert;
    @Autowired
    private RuiShiRespConvert respConvert;
    @Autowired
    private RuiShiProperties ruiShiProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected RuiShiRsp invokeDsp(RuiShiReq ruiShiReq) {
        if (ruiShiReq == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u745e\u72eeDSP\u8c03\u7528");
        try {
            return (RuiShiRsp)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.ruiShiProperties.getUrl(), ruiShiReq), (String)"invokeDSP", (String)"ruishi");
        }
        catch (Throwable t) {
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u745e\u72ee\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private RuiShiRsp doHttpInvoke(String url, RuiShiReq ruiShiReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)ruiShiReq, (MultiValueMap)headers);
        ResponseEntity exchange = null;
        try {
            exchange = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u745e\u72ee\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        SamplerLog.info((String)"\u745e\u72ee \u8fd4\u56de {}", (Object[])new Object[]{exchange});
        JSONObject body = (JSONObject)exchange.getBody();
        if (body == null) {
            return null;
        }
        Integer code = body.getInteger("code");
        if (code == 204) {
            return null;
        }
        Cat.logMetricForCount((String)"\u745e\u72eeDSP\u8fd4\u56de");
        String id = body.getString("id");
        String bidid = body.getString("bidid");
        RuiShiRsp rsp = new RuiShiRsp();
        rsp.setCode(code);
        rsp.setId(id);
        rsp.setBidid(bidid);
        JSONObject seatbid = body.getJSONArray("seatbid").getJSONObject(0);
        JSONObject bidObj = seatbid.getJSONArray("bid").getJSONArray(0).getJSONObject(0);
        Bid bid = (Bid)JSONObject.parseObject((String)bidObj.toJSONString(), Bid.class);
        rsp.setBid(bid);
        return rsp;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return clickCrypto.encodePriceMicros(price.multiply(ONEHUNDRED).longValue(), null);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_11.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_11;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public RuiShiReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(RuiShiRsp ruiShiRsp) throws DspException {
        if (ruiShiRsp == null) {
            return null;
        }
        return this.respConvert.convert(ruiShiRsp);
    }

    static {
        try {
            DoubleClickCrypto.Keys keys = new DoubleClickCrypto.Keys((SecretKey)new SecretKeySpec(KEY1, "HmacSHA1"), (SecretKey)new SecretKeySpec(KEY2, "HmacSHA1"));
            clickCrypto = new DoubleClickCrypto.Price(keys);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

