package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver.MeituanReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver.MeituanRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.github.luben.zstd.Zstd;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

@Slf4j
@Component
public class MeituanDspInvoker extends AbstractDspCaller<MeituanRTB.RtbResponse, MeituanRTB.RtbRequest> {
    @Autowired
    private MeituanReqConvert reqConvert;

    @Autowired
    private MeituanRespConvert respConvert;

    @Autowired
    private MeituanProperties meituanProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    @Override
    protected MeituanRTB.RtbResponse invokeDsp(MeituanRTB.RtbRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount("美团DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(meituanProperties.getUrl(), rtbRequest), "invokeDSP", "meituan");
        } catch (Throwable t) {
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                log.warn("美团调用异常", t);
                Cat.logMetricForCount("美团_竞价失败");
            }
        }
        return null;
    }

    private MeituanRTB.RtbResponse doHttpInvoke(String url, MeituanRTB.RtbRequest rtbRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf;charset=UTF-8");
        headers.add("Content-Encoding", "zstd");
        headers.add("Accept-Encoding", "zstd");
        byte[] compressData = Zstd.compress(rtbRequest.toByteArray());
        HttpEntity<byte[]> entity = new HttpEntity<>(compressData, headers);
        ResponseEntity<byte[]> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class);
        } catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn("美团调用异常", e);
            }
            return null;
        }
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (HttpStatus.NO_CONTENT.equals(statusCode)) {
            return null;
        }

        byte[] body = responseEntity.getBody();
        if (body == null) {
            return null;
        }
        int frameContentSize = (int) Zstd.getFrameContentSize(body);
        if (frameContentSize < 0) {
            SamplerLog.info("美团 response {}", responseEntity);
            return null;
        }
        byte[] array = new byte[frameContentSize];
        Zstd.decompress(array, body);
        try {
            MeituanRTB.RtbResponse rtbResponse = MeituanRTB.RtbResponse.parseFrom(array);
            if (CollectionUtils.isNotEmpty(rtbResponse.getBidsList())) {
                Cat.logMetricForCount("美团DSP返回");
                return rtbResponse;
            }
        } catch (InvalidProtocolBufferException e) {
            SamplerLog.warn("美团返回数据解析失败", e);
        }
        return null;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            SecretKey secretKey = new SecretKeySpec(meituanProperties.getPriceKey().getBytes(), "AES");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] encrypted = cipher.doFinal(tme.getBytes());
            String encode = Base64.getEncoder().encodeToString(encrypted);
            return URLEncoder.encode(encode, "UTF-8");
        } catch (Exception e) {
            log.warn("美团加密失败 ", e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
//        String price = "12301";
//        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
//        SecretKey secretKey = new SecretKeySpec("279cac9ad46c7bd128fc7874d2edbf2f".getBytes(), "AES");
//        cipher.init(Cipher.ENCRYPT_MODE, secretKey);
//        byte[] encrypted = cipher.doFinal(price.getBytes());
//        String s = Base64.getEncoder().encodeToString(encrypted);
//        System.out.println(URLEncoder.encode(s, "UTF-8"));
//        String json = "{\"request_id\": \"15ae86e334f54c0197023b8852ae4c76\",\"time_ms\": 100,\"advertiser_id\": \"meituan\",\"bids\": [{\"ads\": [{\"ad_id\": \"meituan_ad\",\"bid_price\": 18880,\"tempalte_id\": \"1\",\"promotion_types\": [\"DEEPLINK\"],\"image_size\": {\"width\": 720,\"height\": 1280},\"image_urls\": [\"https://p0.meituan.net/union/242fc355943761fe0439f3c1fdb60211140856.jpg\"],\"target_url\": \"https://i.meituan.com/\",\"deeplink_url\": \"imeituan://www.meituan.com/page\",\"download_url\": \"https://h5.gdt.qq.com/xjviewer/nemo/4958497\",\"universal_link\": \"https://i.meituan.com/web?_page_new=1&url=https%3A%2F%2Fyyds.meituan.com%2Flightbox%2Fsource.html\",\"title\": \"美团发钱了：最高领100元\",\"description\": \"美团发福利了，天天抽奖赢100元现金红包，千万不要错过\",\"icon\": \"https://p0.meituan.net/poicreative/758b3d0fe3de1b20e59bbd139d4f37149552.png\",\"app_name\": \"美团\",\"package_name\": \"com.sankuai.meituan\",\"market_id\": \"com.meituan.imeituan\",\"win_notice_urls\": [\"https://adxmanagment.meituan.com/sandbox/impandclick/winnotice?p={AUCTION_PRICE}&templateId=1&siteUri=tuia&requestId=15ae86e334f54c0197023b8852ae4c76&priceType=CPM_PRICE&dcp=%5BB%3D%4028d3af34\"],\"imp_urls\": [\"https://adxmanagment.meituan.com/sandbox/impandclick/show?p={AUCTION_PRICE}&templateId=1&siteUri=tuia&requestId=15ae86e334f54c0197023b8852ae4c76&priceType=CPM_PRICE&dcp=%5BB%3D%4028d3af34\"],\"click_urls\": [\"https://adxmanagment.meituan.com/sandbox/impandclick/click?templateId=1&siteUri=tuia&requestId=15ae86e334f54c0197023b8852ae4c76&priceType=CPM_PRICE&dcp=%5BB%3D%4028d3af34\"],\"price_type\": \"CPM_PRICE\"}]}],\"block_device_id\": false}";
//        //json转成protobuf对象
//        MeituanRTB.RtbResponse.Builder builder = MeituanRTB.RtbResponse.newBuilder();
//        JsonFormat.parser().merge(json, builder);
//        MeituanRTB.RtbResponse rtbResponse = builder.build();
//        byte[] compress = Zstd.compress(rtbResponse.toByteArray());
//        int frameContentSize = (int) Zstd.decompressedSize(compress);
//        byte[] resp = new byte[frameContentSize];
//        Zstd.decompress(resp, compress);
//        MeituanRTB.RtbResponse r = MeituanRTB.RtbResponse.parseFrom(resp);
//        System.out.println(r.toString());
        String url = "https://impdsp.meituan.com/show?dcp=vjgznAyzsSVxR9gRDsLs0DV8cTooAAQ0R-EjUn3w47qaSQnnzss5OIFHGNZdjy3FqMLY2GEOJS0gYTHG0nzvzRlL3vktq_AqfCuHmat2w_vkLwSKUdR8pciz1BH_xhQsKp5ebsdlA2qH3S-hZxzotXv_JMFfXZlskFcaUzWxKXnvZDW7PXv4jibusUXOAeCwmvU_bO5NoRiCl_KLlomxIzrVT2KIavNX8pxEE3vkt3PXUhi5BwXwuKCn0g9UXsjnzKuW_8CprCmIufL94_Nf3DpXQBpLPm_aZJaAOFqFnkaoN4THVRYvYGz13W08sEvb65ElzaWCCuBYW_LRrvOsd13VpV1veikEAygmmXNtaBJJZZ9Ry1WQfdhvWIlEgqJe_PdQM2j2XW6Rzuh26KLQXXJmw4qIRD-bnwJqSYbtK0qUCkVQrdc43gIliojz4NsYLTwyXfTdWIOfsyhpiZpJ&driverid=349a3b9eac6e15d016738d3d3b675640&p={AUCTION_PRICE}";
        MeituanDspInvoker meituanDspInvoker = new MeituanDspInvoker();
        String s1 = meituanDspInvoker.replaceUrl("I6TO%2FHvxU%2BfUn36ILuObvQ%3D%3D", url);
        System.out.println(s1);
    }


    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_12.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_12;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("{AUCTION_PRICE}") && price != null) {
            url = url.replace("{AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public MeituanRTB.RtbRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(MeituanRTB.RtbResponse rtbResponse) throws DspException {
        return respConvert.convert(rtbResponse);
    }
}
