package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.util.RedisBalanceKeyUtil;
import cn.com.duiba.spring.boot.starter.dsp.util.RedisBloomHandler;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert.QiHangJsonReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert.QiHangJsonRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangRealReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangResp;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.concurrent.ExecutorService;

@Slf4j
@Component
public class QiHangDspInvoker extends AbstractDspCaller<QiHangResp, QiHangRealReq> {
    @Autowired
    private QiHangJsonReqConvert qiHangJsonReqConvert;
    @Autowired
    private QiHangJsonRespConvert qiHangJsonRespConvert;
    //    @Autowired
//    private QiHangRespConvert qiHangRespConvert;
    @Autowired
    private QiHandProperties qiHandProperties;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    @Resource(name = "redisBloom2StringRedisTemplate")
    private RedisTemplate redisTemplate;

    @Resource
    private RedisBloomHandler redisBloomHandler;

    @Autowired
    private ExecutorService executorService;

    private static final String LOCATION_DEVICE_BLOOM_PREFIX = "adx_location_device_bloom_";

    @Override
    protected QiHangResp invokeDsp(QiHangRealReq bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount("启航DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(qiHandProperties.getUrl(), bidRequest), "invokeDSP", "qihang");
        } catch (Throwable t) {
            Cat.logMetricForCount("启航_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("启航调用异常", t);
            }
        }
        return null;
    }

    private QiHangResp doHttpInvoke(String url, QiHangRealReq bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity<QiHangReq> requestEntity = new HttpEntity<>(bidRequest.getQiHangReq(), headers);
        ResponseEntity<QiHangResp> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, QiHangResp.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("启航调用异常 response is {}", resEntity, e);
            }
            return null;
        }
        QiHangResp body = resEntity.getBody();
        if (body == null) {
            return null;
        }

        if (body.getNbr() == 9) {
            //写入黑名单
            ResponseEntity<QiHangResp> finalResEntity = resEntity;
            executorService.execute(() -> {
                String currentDayStr = LocalDate.now().toString();
                String baseKey = StringUtils.join(LOCATION_DEVICE_BLOOM_PREFIX, currentDayStr);
                String redisBalance8key = RedisBalanceKeyUtil.getRedisBalance8key(baseKey, bidRequest.getTuiaDeviceId());
                redisBloomHandler.addString(redisTemplate, redisBalance8key, bidRequest.getTuiaDeviceId());
                SamplerLog.info("启航 写入黑名单 {}", finalResEntity);
            });
        }
        if (CollectionUtils.isEmpty(body.getSeat_bid())) {
            return null;
        }
        Cat.logMetricForCount("启航DSP返回");
        return body;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            SecretKeySpec secretKey = new SecretKeySpec("BzABOvVhLYJiuo3Y".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] bytes = cipher.doFinal(tme.getBytes(StandardCharsets.UTF_8));
            //2进制转换成16进制
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex);
            }
            return sb.toString();
        } catch (Exception e) {
            log.warn("启航加密失败 ", e);
        }
        return null;
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_10.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_10;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public QiHangRealReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return qiHangJsonReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(QiHangResp bidResponse) throws DspException {
        return qiHangJsonRespConvert.convert(bidResponse);
    }
}
