package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class MeituanReqConvert {
    @Autowired
    private AppReplace appReplace;

    public MeituanRTB.RtbRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.RtbRequest.Builder builder = MeituanRTB.RtbRequest.newBuilder();
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setAdxName("tuia");
        MeituanRTB.Device.Builder device = convertDevice(adxCommonBidRequest, dspInfo);
        if (device == null) {
            return null;
        }
        builder.setDevice(device);
        MeituanRTB.LocationInfo.Builder location = convertLocation(adxCommonBidRequest, dspInfo);
        builder.setLocation(location);
        MeituanRTB.AdSlot.Builder adslot = convertAdslot(adxCommonBidRequest, dspInfo);
        builder.addAdslots(adslot);
        MeituanRTB.App.Builder app = convertApp(adxCommonBidRequest, dspInfo);
        builder.setApp(app);
        builder.setToken("5GQKxC6L0Cli/g6y");
        return builder.build();
    }

    private MeituanRTB.App.Builder convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.App.Builder app = MeituanRTB.App.newBuilder();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setAppName(replaceApp.getName());
            app.setPackageName(replaceApp.getBundle());
        } else {
            if (appInfo.getName() != null) {
                app.setAppName(appInfo.getName());
            }
            app.setPackageName(appInfo.getBundle());
        }
        return app;
    }

    private MeituanRTB.AdSlot.Builder convertAdslot(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.AdSlot.Builder adSlot = MeituanRTB.AdSlot.newBuilder();
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        String slotId = BlowfishUtils.encryptBlowfish(commonImp.getExternalAdBlockId(), "abc");
        adSlot.setAdslotId(dspInfo.getIdeaId() + slotId);
        MeituanRTB.TemplateInfo.Builder template = MeituanRTB.TemplateInfo.newBuilder();
        template.setTemplateId(dspInfo.getDspTemplateId());
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        if (commonSizeInfo.getType() == 3) {
            MeituanRTB.Video.Builder video = MeituanRTB.Video.newBuilder();
            video.addVideoTypes(MeituanRTB.VideoType.VT_UNKNOWN);
            if (commonSizeInfo.getMinduration() != null) {
                video.setMinduration(commonSizeInfo.getMinduration());
            }
            if (commonSizeInfo.getMaxduration() != null) {
                video.setMaxduration(commonSizeInfo.getMaxduration());
            }
            template.setVideo(video);

        }
        adSlot.addTemplates(template);
        adSlot.setIsHttps(commonImp.isLinkAgreement());
        if (dspInfo.getCpcCharge() == 1) {
            adSlot.addPriceTypes(MeituanRTB.PriceType.CPC_PRICE);
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getCpcFloorPrice(), dspInfo);
            adSlot.setCpcFloor(floorPrice * 1000);
        } else {
            long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
            adSlot.setFloor(floorPrice);
            adSlot.addPriceTypes(MeituanRTB.PriceType.CPM_PRICE);
        }
        return adSlot;
    }

    private MeituanRTB.LocationInfo.Builder convertLocation(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonDevice device = adxCommonBidRequest.getDevice();
        CommonGeo geo = device.getGeo();

        MeituanRTB.LocationInfo.Builder location = MeituanRTB.LocationInfo.newBuilder();
        if (geo != null) {
            location.setLatitude(geo.getLat());
            location.setLongitude(geo.getLon());
        }

        String ip = device.getIp();
        //判断ipv4 ipv6
        if (ip.contains(":")) {
            location.setIpv6(ip);
        } else {
            location.setIpv4(ip);
        }
        location.setLatLonType(MeituanRTB.LatLonType.WGS84);
        return location;
    }

    private MeituanRTB.Device.Builder convertDevice(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MeituanRTB.Device.Builder device = MeituanRTB.Device.newBuilder();

        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        if (StringUtils.isNotBlank(commonDevice.getImei())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getImei());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IMEI);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getImeiMd5())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getImeiMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IMEI);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getIdFa())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getIdFa());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IDFA);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getIdFaMd5())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getIdFaMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.IDFA);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getOaId())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getOaId());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.OAID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getOaIdMd5())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getOaIdMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.OAID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getDpId())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getDpId());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.ANDROID_ID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }
        if (StringUtils.isNotBlank(commonDevice.getDpIdMd5())) {
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(commonDevice.getDpIdMd5());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.ANDROID_ID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.MD5);
            device.addDeviceIds(deviceId);
        }
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            Caid caid = commonDevice.getCaids().get(0);
            MeituanRTB.DeviceId.Builder deviceId = MeituanRTB.DeviceId.newBuilder();
            deviceId.setId(caid.getId());
            deviceId.setDeviceIdType(MeituanRTB.DeviceIdType.CAID);
            deviceId.setEncryptionType(MeituanRTB.EncryptionType.PLAINTEXT);
            device.addDeviceIds(deviceId);
        }

        String os = commonDevice.getOs();
        if (os == null) {
            return null;
        }

        if ("1".equals(commonDevice.getOs())) {
            device.setPlateformType(MeituanRTB.DevicePlatformType.DPT_IOS);
        } else if ("0".equals(commonDevice.getOs())) {
            device.setPlateformType(MeituanRTB.DevicePlatformType.DPT_ANDROID);
        } else {
            device.setPlateformType(MeituanRTB.DevicePlatformType.DPT_UNKNOWN);
        }
        if (StringUtils.isNotBlank(commonDevice.getCarrier())) {
            String carrier = commonDevice.getCarrier();
            if ("1".equals(carrier)) {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_MOBILE);
            } else if ("2".equals(carrier)) {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_UNICOM);
            } else if ("3".equals(carrier)) {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_TELECOM);
            } else {
                device.setOperatiorType(MeituanRTB.DeviceOperatorType.DOT_UNKNOWN);
            }
        }
        if (commonDevice.getTuiaConnectionType() != null) {
            Integer connectionType = commonDevice.getTuiaConnectionType();
            if (connectionType == 2) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_WIFI);
            } else if (connectionType == 4) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_2G);
            } else if (connectionType == 5) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_3G);
            } else if (connectionType == 6) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_4G);
            } else if (connectionType == 7) {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_5G);
            } else {
                device.setNetworkType(MeituanRTB.NetworkType.NETWORK_UNKNOWN);
            }
        }
        if (StringUtils.isNotBlank(commonDevice.getMake())) {
            device.setBrand(commonDevice.getMake());
        }
        if (StringUtils.isNotBlank(commonDevice.getModel())) {
            device.setModel(commonDevice.getModel());
        }
        if (StringUtils.isNotBlank(commonDevice.getOsVersion())) {
            device.setOsVersion(commonDevice.getOsVersion());
        }
        if (StringUtils.isNotBlank(commonDevice.getUa())) {
            device.setUa(commonDevice.getUa());
        }

        return device;
    }
}
