package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.protobuf.ProtocolStringList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class MeituanRespConvert {

    public AdxCommonBidResponse convert(MeituanRTB.RtbResponse rtbResponse) {
        if (rtbResponse == null) {
            return null;
        }
        List<MeituanRTB.Bid> bidsList = rtbResponse.getBidsList();
        if (CollectionUtils.isEmpty(bidsList)) {
            return null;
        }
        MeituanRTB.Bid bid = bidsList.get(0);
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(rtbResponse.getRequestId());
        response.setDspId(DspEnum.DSP_12.getDspId());
        MeituanRTB.Ad ads = bid.getAds(0);
        CommonSeatBid commonSeatBid = bidConvert(ads);
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);

        return response;
    }

    private CommonSeatBid bidConvert(MeituanRTB.Ad ads) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        MeituanRTB.PriceType priceType = ads.getPriceType();
        if (MeituanRTB.PriceType.CPC_PRICE.equals(priceType)) {
            //cpc价格除以1000 美团返回是分/千次点击
            commonSeatBid.setPrice(ads.getBidCpcPrice() / 1000.0);
            commonSeatBid.setPriceType(1);
        } else {
            commonSeatBid.setPrice((double) ads.getBidPrice());
        }

        ProtocolStringList winNoticeUrlsList = ads.getWinNoticeUrlsList();
        List<String> winUrls = new ArrayList<>(winNoticeUrlsList);
        commonSeatBid.setWinCallbackUrls(winUrls);
        ProtocolStringList impUrlsList = ads.getImpUrlsList();
        List<String> exposureUrls = new ArrayList<>(impUrlsList);
        commonSeatBid.setExposureCallbackUrls(exposureUrls);
        ProtocolStringList clickUrlsList = ads.getClickUrlsList();
        List<String> clickUrls = new ArrayList<>(clickUrlsList);
        commonSeatBid.setClickCallbackUrls(clickUrls);
        commonSeatBid.setCommonContext(context);

        CommonCreative commonCreative = new CommonCreative();
        String iconUrl = ads.getIcon();
        String bundle = ads.getPackageName();
        commonCreative.setAppName(ads.getAppName());
        commonCreative.setAppBundle(bundle);
        commonCreative.setIconUrl(iconUrl);
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(iconUrl);
        commonCreative.setCommonIcon(commonIcon);
        MeituanRTB.Size imageSize = ads.getImageSize();

        if (ads.hasVideo()) {
            MeituanRTB.VideoMaterial video = ads.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideoUrl());
            commonVideo.setResolutionX(imageSize.getWidth());
            commonVideo.setResolutionY(imageSize.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getVideoDuration()));
            commonVideo.setSize((int) video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(video.getCoverUrl());
            commonVideo.setCoverWidth(imageSize.getWidth());
            commonVideo.setCoverHeight(imageSize.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<CommonImage> commonImages = new ArrayList<>();
            for (String url : ads.getImageUrlsList()) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(url);
                commonImage.setHeight(imageSize.getHeight());
                commonImage.setWidth(imageSize.getWidth());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank(ads.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(ads.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(ads.getDescription())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(ads.getDescription());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (StringUtils.isNotBlank(ads.getDeeplinkUrl())) {
            commonCreative.setDeepLinkUrl(ads.getDeeplinkUrl());
            context.setDeepLinkUrl(ads.getDeeplinkUrl());
        }
        if (StringUtils.isNotBlank(ads.getUniversalLink())) {
            commonCreative.setULinkUrl(ads.getUniversalLink());
            context.setULinkUrl(ads.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(ads.getTargetUrl());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}
