package cn.com.duiba.tuia.dsp.engine.api.enums;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.AlipayDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.fancy.FancyDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.GuangtuiDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.HuichuanDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.IqiyiDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.JinghongDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.JuMeiDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.admobile.AdMobileDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.BuLuKenDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.FireflyDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jutui.JutuiDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.KuaishouDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.lingmo.LingMoDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.MeituanDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.MoYiDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pddzy.PddZYDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.QiHangDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.RgyunDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.RuiShiDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.TanxDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.TianGongDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.YouKuDspInvoker;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * dspId 对应的竞价url
 *
 * @author lijian
 * @date 2020/04/13
 * @since JDK 1.8
 */
public enum DspEnum {


    /*DSP_1(1L, "http://172.16.47.169:17788/adxAdvert/comparePrice", "ab3128977c94a115f64d64cb5ba4379c", "58同城"),*/
//    DSP_2(2L, "京准通", null),
    DSP_3(3, "拼多多", PddDspInvoker.class),
    DSP_4(4, "软告", RgyunDspInvoker.class),
    DSP_5(5, "Tanx", TanxDspInvoker.class),

    DSP_6(6, "布鲁肯", BuLuKenDspInvoker.class),

    DSP_7(7, "沫易", MoYiDspInvoker.class),
    DSP_8(8, "快手", KuaishouDspInvoker.class),
    DSP_9(9, "ADMobile", AdMobileDspInvoker.class),
    DSP_10(10, "启航", QiHangDspInvoker.class),
    DSP_11(11, "瑞狮", RuiShiDspInvoker.class),
    DSP_12(12, "美团", MeituanDspInvoker.class),
    DSP_13(13, "领摩", LingMoDspInvoker.class),
    DSP_14(14, "萤火虫", FireflyDspInvoker.class),
    DSP_15(15, "聚媒", JuMeiDspInvoker.class),
    DSP_16(16, "爱奇艺", IqiyiDspInvoker.class),
    DSP_17(17, "泛为", FancyDspInvoker.class),
    DSP_18(18, "优酷", YouKuDspInvoker.class),
    DSP_19(19, "拼多多-zy", PddZYDspInvoker.class),
    DSP_20(20, "天宫", TianGongDspInvoker.class),
    DSP_21(21, "超级汇川", HuichuanDspInvoker.class),
    DSP_22(22, "广推", GuangtuiDspInvoker.class),
    DSP_24(24, "鲸鸿动能", JinghongDspInvoker.class),
    DSP_25(25, "支付宝",  AlipayDspInvoker.class),
    DSP_26(26, "聚推",  JutuiDspInvoker.class),
    ;

    private final Integer dspId;

    //dsp平台名称
    private final String desc;

    private final Class<? extends AbstractDspCaller> clazz;

    DspEnum(Integer dspId, String desc, Class<? extends AbstractDspCaller> clazz) {
        this.dspId = dspId;
        this.desc = desc;
        this.clazz = clazz;
    }

    public Integer getDspId() {
        return dspId;
    }

    public String getDesc() {
        return desc;
    }

    public Class<? extends AbstractDspCaller> getClazz() {
        return clazz;
    }

    private static Map<Integer, DspEnum> dspMap = Maps.newHashMap();

    static {
        for (DspEnum it : DspEnum.values()) {
            dspMap.put(it.getDspId(), it);
        }
    }

    public static DspEnum getByDspId(Integer dspId) {
        return dspMap.get(dspId);
    }

    public static Class<? extends AbstractDspCaller> getClazzByDspId(Integer dspId) {
        return dspMap.get(dspId).getClazz();
    }

}
