package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2022/10/9
 * @Description
 * @Param
 * @return
 **/

public class OsConverter {

    public static final String ANDROID = "0";
    public static final String IOS = "1";
    public static final String HARMONY_OS = "4";

    public static KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem getOsType(String os, UAData uaData) {
        if (StringUtils.isBlank(os)) {
            return getOsByUa(uaData);
        }
        switch (os) {
            case ANDROID:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.OS_ANDROID;
            case IOS:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.OS_IOS;
            case HARMONY_OS:
                return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.OS_ANDROID;
            default:
                return getOsByUa(uaData);
        }
    }


    private static KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem getOsByUa(UAData uaData) {
        if (Objects.isNull(uaData)) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.UNRECOGNIZED;
        }
        if (Objects.equals(uaData.getOsType(), "Android")) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.OS_ANDROID;
        }
        if (Objects.equals(uaData.getOsType(), "iOS")) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.OS_IOS;
        }
        return KuaishouBidRequestOuterClass.KuaishouBidRequest.OperatingSystem.OS_UNKNOWN;
    }
}
