package cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tiangong.bean.TgSsp;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class TianGongRespConvert {
    public AdxCommonBidResponse convert(TgSsp.Response response) {
        TgSsp.Response.Ad ad = response.getAd();
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setRequestId(response.getImpressionId());
        adxCommonBidResponse.setDspId(DspEnum.DSP_20.getDspId());
        List<CommonSeatBid> commonSeatBidList = seatBidConvert(ad);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBidList);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(TgSsp.Response.Ad ad) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        CommonCreative commonCreative = new CommonCreative();
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        if (StringUtils.isNotBlank(ad.getTitle())) {
            CommonTitle title = new CommonTitle();
            title.setTitle(ad.getTitle());
            commonCreative.setCommonTitle(title);
        }
        if (StringUtils.isNotBlank(ad.getSubTitle())) {
            CommonDesc desc = new CommonDesc();
            desc.setDesc(ad.getSubTitle());
            commonCreative.setCommonDesc(desc);
        }
        if (StringUtils.isNotBlank(ad.getSourceAvatar())) {
            CommonIcon icon = new CommonIcon();
            icon.setUrl(ad.getSourceAvatar());
            commonCreative.setCommonIcon(icon);
            commonCreative.setIconUrl(ad.getSourceAvatar());
        }
        String creativeDomain = ad.getCreativeDomain();
        List<TgSsp.Response.Ad.Creative> creativeList = ad.getCreativeList();
        TgSsp.Response.Ad.Creative creative = creativeList.get(0);
        String creativeUrl = creative.getCreativeUrl();
        String url = creativeDomain + creativeUrl;
        CommonImage image = new CommonImage();
        image.setUrl(url);
        List<CommonImage> commonImageList = new ArrayList<>();
        commonImageList.add(image);
        commonCreative.setCommonImageList(commonImageList);
        //串行 并行判断
        if (StringUtils.isNotBlank(ad.getJdClickUrl())) {
            //并行
            if (StringUtils.isNotBlank(ad.getJdOpenUrl())) {
                commonCreative.setDeepLinkUrl(ad.getJdOpenUrl());
                context.setDeepLinkUrl(ad.getJdOpenUrl());
            }
            if (StringUtils.isNotBlank(ad.getJdULinkUrl())) {
                commonCreative.setULinkUrl(ad.getJdULinkUrl());
                context.setULinkUrl(ad.getJdULinkUrl());
            }
            commonCreative.setLandingPageUrl(ad.getJdClickUrl());
            String jdImpUrl = ad.getJdImpUrl();
            List<String> exposureUrls = new ArrayList<>();
            exposureUrls.add(jdImpUrl);
            if (StringUtils.isNotBlank(ad.getThirdImpUrl())) {
                exposureUrls.add(ad.getThirdImpUrl());
            }
            commonSeatBid.setExposureCallbackUrls(exposureUrls);

            List<String> clickUrls = new ArrayList<>();
            if (StringUtils.isNotBlank(ad.getThirdClickUrl())) {
                clickUrls.add(ad.getThirdClickUrl());
            }
            if (CollectionUtils.isNotEmpty(ad.getExtendClickUrlsList())) {
                clickUrls.addAll(ad.getExtendClickUrlsList());
            }
            if (CollectionUtils.isNotEmpty(clickUrls)) {
                commonSeatBid.setClickCallbackUrls(clickUrls);
            }
        } else {
            //串行
            if (StringUtils.isNotBlank(ad.getOpenUrl())) {
                commonCreative.setDeepLinkUrl(ad.getOpenUrl());
                context.setDeepLinkUrl(ad.getOpenUrl());
            }
            if (StringUtils.isNotBlank(ad.getULinkUrl())) {
                commonCreative.setULinkUrl(ad.getULinkUrl());
                context.setULinkUrl(ad.getULinkUrl());
            }
            if (StringUtils.isNotBlank(ad.getClickUrl())) {
                commonCreative.setLandingPageUrl(ad.getClickUrl());
            }
            List<String> exposureUrls = new ArrayList<>();
            if (StringUtils.isNotBlank(ad.getImpressionUrl())) {
                exposureUrls.add(ad.getImpressionUrl());
            }
            commonSeatBid.setExposureCallbackUrls(exposureUrls);
            List<String> clickUrls = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(ad.getExtendClickUrlsList())) {
                clickUrls.addAll(ad.getExtendClickUrlsList());
            }
            commonSeatBid.setClickCallbackUrls(clickUrls);
        }

        commonSeatBid.setCommonCreative(commonCreative);
        commonSeatBidList.add(commonSeatBid);
        return commonSeatBidList;
    }


}
