package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
@Slf4j
public class QiHangJsonRespConvert {

    public AdxCommonBidResponse convert(QiHangResp bidResponse) {
        if (bidResponse == null) {
            return null;
        }
        List<SeatBid> seat_bid = bidResponse.getSeat_bid();
        if (CollectionUtils.isEmpty(seat_bid)) {
            return null;
        }
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(DspEnum.DSP_10.getDspId());
        SeatBid seatBid = seat_bid.get(0);
        Bid bid = seatBid.getBid().get(0);
        CommonSeatBid commonSeatBid = bidConvert(bid);
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        response.setUserScoreLevel(bid.getUser_score_level());

        return response;
    }

    private CommonSeatBid bidConvert(Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
//        commonSeatBid.setAdvertiserId();
        commonSeatBid.setPrice((double) bid.getPrice());
        commonSeatBid.setPriceType(bid.getBid_type());
        String nurl = bid.getNurl();
        commonSeatBid.setWinCallbackUrls(Collections.singletonList(nurl));
        commonSeatBid.setExposureCallbackUrls(bid.getImp_trackers());
        commonSeatBid.setClickCallbackUrls(bid.getClk_trackers());
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setAppName(bid.getApp_name());
        String bundle = bid.getPackage_name();
        if (StringUtils.isBlank(bundle)) {
            bundle = "com.taobao.taobao";
        }
        commonCreative.setAppBundle(bundle);
        commonCreative.setIconUrl(bid.getIcon_url());
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(bid.getIcon_url());
        commonCreative.setCommonIcon(commonIcon);
        commonCreative.setMaterialId(bid.getCreative_id());
        Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank(adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        //根据是否有视频判断素材类型 非视频就是图片
        if (adm.getVideo() != null) {
            Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideo_url());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(adm.getCover_img_url());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<Image> imageList = adm.getImage();
            List<CommonImage> commonImages = new ArrayList<>(imageList.size());
            for (Image image : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image.getUrl());
                commonImage.setWidth(image.getWidth());
                commonImage.setHeight(image.getHeight());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank(adm.getDeep_link())) {
            commonCreative.setDeepLinkUrl(adm.getDeep_link());
            context.setDeepLinkUrl(adm.getDeep_link());
            String dspTaskId = getDspTaskId(adm.getDeep_link());
            commonCreative.setDspTaskId(dspTaskId);
        }
        if (StringUtils.isNotBlank(adm.getUniversal_link())) {
            commonCreative.setULinkUrl(adm.getUniversal_link());
            context.setULinkUrl(adm.getUniversal_link());
        }
        commonCreative.setLandingPageUrl(adm.getLanding_site());
        commonSeatBid.setCommonCreative(commonCreative);

        return commonSeatBid;
    }

    private String getDspTaskId(String deepLinkUrl) {
        try {
            deepLinkUrl = URLDecoder.decode(deepLinkUrl, "UTF-8");
            if (deepLinkUrl.contains("bc_fl_src")) {
                String[] params = deepLinkUrl.split("&");
                for (String param : params) {
                    if (param.startsWith("bc_fl_src")) {
                        String[] keyValue = param.split("=");
                        if (keyValue.length == 2) {
                            return keyValue[1].split("-")[2];
                        }
                    }
                }
            }
        } catch (Exception e) {
//            log.warn("获取taskId失败 deeplinkUrl is {}", deepLinkUrl, e);
        }
        return null;
    }
}
