/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.adx.center.api.dto.IdeaPriceStrategyDTO;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.adx.center.api.enums.DspTargetType;
import cn.com.duiba.tuia.adx.center.api.remoteservice.RemoteResourceIdeaService;
import cn.com.duiba.tuia.dsp.engine.api.util.StringRedisHandler;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BidStatService {
    private static final Logger log = LoggerFactory.getLogger(BidStatService.class);
    private static final String OMD = "OMD_";
    private static final String DAY = "1";
    private static final String HOUR = "2";
    private static final String MINUTE = "3";
    private static final String OCD1 = "OCD1_";
    private static final String OCD3 = "OCD3_";
    private static final String PCTR = "pctr_";
    private static final String PCVR = "pcvr_";
    private static final String FACTOR = "factor_";
    private static final String LAST_FACTOR = "last_factor_";
    private static final String ROI_FACTOR = "roi_factor_";
    private static final String LASE_ROI_FACTOR = "last_roi_factor_";
    public static final String DEFAULT_PCTR = "0.15";
    private static final String DEFAULT_PCVR = "0.02";
    private static final String DEFAULT_FACTOR = "1.0";
    @Resource
    private ExecutorService executorService = Executors.newFixedThreadPool(10);
    @Resource
    private StringRedisHandler stringRedisHandler;
    @Resource
    private RemoteResourceIdeaService remoteResourceIdeaService;
    private AsyncLoadingCache<String, Optional<Map<String, JSONObject>>> omdDataCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MINUTES).executor((Executor)this.executorService).buildAsync(key -> Optional.of(this.getData((String)key)));
    private AsyncLoadingCache<String, Optional<Map<String, JSONObject>>> omcDataCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MINUTES).executor((Executor)this.executorService).buildAsync(key -> Optional.of(this.getOmcData((String)key)));
    private AsyncLoadingCache<Long, Optional<ResourceIdeaDto>> resourceIdeaCache = Caffeine.newBuilder().refreshAfterWrite(2L, TimeUnit.MINUTES).buildAsync(key -> {
        try {
            return Optional.ofNullable(this.remoteResourceIdeaService.getIdeaById(key));
        }
        catch (Exception e) {
            log.warn(String.format("load resourceIdeaCache error: %s", key), (Throwable)e);
            return Optional.empty();
        }
    });
    private AsyncLoadingCache<String, Optional<String>> pCTRCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.SECONDS).executor((Executor)this.executorService).buildAsync(key -> {
        try {
            if (StringUtils.isBlank((CharSequence)key)) {
                return Optional.of(DEFAULT_PCTR);
            }
            String[] s = key.split("_");
            if (s.length == 4) {
                String resourceId = s[0];
                String ideaId = s[1];
                String appId = s[2];
                String slotId = s[3];
                Double pCtr = this.calculatePCTR(resourceId, ideaId, appId, slotId);
                if (pCtr != null) {
                    return Optional.of(String.valueOf(pCtr));
                }
                return Optional.empty();
            }
            if (s.length == 3) {
                String redisKey = PCTR + key;
                String resourceId = s[0];
                String appId = s[1];
                String slotId = s[2];
                Double pCtr = this.calculatePCTR(resourceId, null, appId, slotId);
                if (pCtr != null) {
                    return Optional.of(String.valueOf(pCtr));
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("load pCTRCache error: %s", key), (Throwable)e);
        }
        return Optional.of(DEFAULT_PCTR);
    });
    private AsyncLoadingCache<String, Optional<String>> pCVRCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.SECONDS).executor((Executor)this.executorService).buildAsync(key -> {
        try {
            String slotId;
            String appId;
            String ideaId;
            String resourceId;
            Double pCtr;
            if (StringUtils.isBlank((CharSequence)key)) {
                return Optional.of(DEFAULT_PCVR);
            }
            String[] s = key.split("_");
            if (s.length == 4 && (pCtr = this.calculatePCVR(resourceId = s[0], ideaId = s[1], appId = s[2], slotId = s[3])) != null) {
                return Optional.of(String.valueOf(pCtr));
            }
        }
        catch (Exception e) {
            log.error(String.format("load pCVRCache error: %s", key), (Throwable)e);
        }
        return Optional.of(DEFAULT_PCVR);
    });
    private AsyncLoadingCache<String, Optional<String>> factorCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MINUTES).executor((Executor)this.executorService).buildAsync(key -> {
        try {
            if (StringUtils.isBlank((CharSequence)key)) {
                return Optional.of(DEFAULT_FACTOR);
            }
            String[] s = key.split("_");
            if (s.length != 4) {
                return Optional.empty();
            }
            String resourceId = s[0];
            String ideaId = s[1];
            String appId = s[2];
            String slotId = s[3];
            String redisKey = FACTOR + key;
            Double factor = this.calculateFactor(resourceId, ideaId, appId, slotId);
            if (factor != null && !factor.isNaN()) {
                return Optional.of(String.valueOf(factor));
            }
        }
        catch (Exception e) {
            log.error(String.format("load factorCache error: %s", key), (Throwable)e);
        }
        return Optional.of(DEFAULT_FACTOR);
    });
    private AsyncLoadingCache<String, Optional<String>> roiFactorCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MINUTES).executor((Executor)this.executorService).buildAsync(key -> {
        try {
            String[] s = key.split("_");
            if (s.length != 4) {
                return Optional.empty();
            }
            String resourceId = s[0];
            String ideaId = s[1];
            String appId = s[2];
            String slotId = s[3];
            String redisKey = ROI_FACTOR + key;
            Double roiFactor = this.calculateRoiFactor(resourceId, ideaId, appId, slotId);
            if (roiFactor != null) {
                return Optional.of(String.valueOf(roiFactor));
            }
        }
        catch (Exception e) {
            log.error(String.format("load roiFactorCache error: %s", key), (Throwable)e);
        }
        return Optional.of(DEFAULT_FACTOR);
    });
    private AsyncLoadingCache<String, Optional<String>> qiHangCvrCache = Caffeine.newBuilder().refreshAfterWrite(1L, TimeUnit.MINUTES).executor((Executor)this.executorService).buildAsync(key -> {
        String[] split = key.split("_");
        double qihangCvr = this.getQiHangPCvr(split[0], split[1], split[2], split[3], split[4]);
        return Optional.of(String.valueOf(qihangCvr));
    });

    private Double calculatePCTR(String resourceId, String ideaId, String appId, String slotId) {
        Optional ideaResultMapOptional;
        String baseKey = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        if (StringUtils.isEmpty((CharSequence)ideaId)) {
            baseKey = resourceId + "_" + appId + "_" + slotId;
        }
        if ((ideaResultMapOptional = this.omdDataCache.get((Object)baseKey).getNow(Optional.empty())).isPresent()) {
            String key_min = OMD + baseKey + "_" + MINUTE;
            String key_hour = OMD + baseKey + "_" + HOUR;
            String key_day = OMD + baseKey + "_" + DAY;
            Map resultMap = (Map)ideaResultMapOptional.get();
            if (resultMap.get(key_min) == null && resultMap.get(key_hour) == null && resultMap.get(key_day) == null) {
                SamplerLog.info((String)"ocpm ideaId is {} appId is {} slotId is {} pctr \u83b7\u53d6\u65e0\u6570\u636e", (Object[])new Object[]{ideaId, appId, slotId});
                return null;
            }
            JSONObject value_min = (JSONObject)resultMap.get(key_min);
            JSONObject value_hour = (JSONObject)resultMap.get(key_hour);
            JSONObject value_day = (JSONObject)resultMap.get(key_day);
            if (value_min == null && value_hour == null && value_day == null) {
                return null;
            }
            if (value_min == null) {
                value_min = new JSONObject();
            }
            if (value_hour == null) {
                value_hour = new JSONObject();
            }
            if (value_day == null) {
                value_day = new JSONObject();
            }
            return this.getFusionPCtr(value_min, value_hour, value_day);
        }
        return null;
    }

    private Double getFusionPCtr(JSONObject value_min, JSONObject value_hour, JSONObject value_day) {
        int exposure_day;
        int click_min = value_min != null && value_min.get((Object)"x_c") != null ? value_min.getInteger("x_c") : 0;
        int click_hour = value_hour != null && value_hour.get((Object)"x_c") != null ? value_hour.getInteger("x_c") : 0;
        int click_day = value_day != null && value_day.get((Object)"x_c") != null ? value_day.getInteger("x_c") : 0;
        int exposure_min = value_min != null && value_min.get((Object)"x_e") != null ? value_min.getInteger("x_e") : 0;
        int exposure_hour = value_hour != null && value_hour.get((Object)"x_e") != null ? value_hour.getInteger("x_e") : 0;
        int n = exposure_day = value_day != null && value_day.get((Object)"x_e") != null ? value_day.getInteger("x_e") : 0;
        if (exposure_day == 0 && exposure_hour == 0 && exposure_min == 0) {
            return null;
        }
        if (click_day < 20) {
            return null;
        }
        if (click_hour < 20) {
            return 1.0 * (double)click_day / (double)exposure_day;
        }
        if (click_min < 20) {
            return 0.3 * (double)click_day / (double)exposure_day + 0.7 * (double)click_hour / (double)exposure_hour;
        }
        return 0.1 * (double)click_day / (double)exposure_day + 0.3 * (double)click_hour / (double)exposure_hour + 0.6 * (double)click_min / (double)exposure_min;
    }

    private Double calculatePCVR(String resourceId, String ideaId, String appId, String slotId) {
        String baseKey = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        Optional ideaResultMapOptional = this.omdDataCache.get((Object)baseKey).getNow(Optional.empty());
        if (ideaResultMapOptional.isPresent() && StringUtils.isNotEmpty((CharSequence)ideaId)) {
            String key_min = OMD + baseKey + "_" + MINUTE;
            String key_hour = OMD + baseKey + "_" + HOUR;
            String key_day = OMD + baseKey + "_" + DAY;
            Map resultMap = (Map)ideaResultMapOptional.get();
            Optional ideaOptional = this.resourceIdeaCache.get((Object)Long.valueOf(ideaId)).getNow(Optional.empty());
            if (!ideaOptional.isPresent()) {
                SamplerLog.info((String)"getFusionPcvr \u6ca1\u6709\u627e\u5230\u521b\u610f\u8fd4\u56de\u9ed8\u8ba4\u503c ideaId is {}", (Object[])new Object[]{ideaId});
                return null;
            }
            ResourceIdeaDto resourceIdeaDto = (ResourceIdeaDto)ideaOptional.get();
            IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
            if (ideaPriceStrategyDTO == null) {
                SamplerLog.info((String)"getFusionPcvr \u6ca1\u6709\u627e\u5230\u521b\u610f\u7684\u8f6c\u5316\u7c7b\u578b ideaId is {}", (Object[])new Object[]{ideaId});
                return null;
            }
            Integer targetType = ideaPriceStrategyDTO.getTargetType();
            if (Objects.equals(targetType, DspTargetType.MATERIAL_CLICK.getValue())) {
                return 1.0;
            }
            if (resultMap.get(key_min) == null && resultMap.get(key_hour) == null && resultMap.get(key_day) == null) {
                SamplerLog.info((String)"ocpm pcvr \u83b7\u53d6\u65e0\u6570\u636e", (Object[])new Object[0]);
                return null;
            }
            JSONObject value_min = (JSONObject)resultMap.get(key_min);
            JSONObject value_hour = (JSONObject)resultMap.get(key_hour);
            JSONObject value_day = (JSONObject)resultMap.get(key_day);
            if (value_min == null && value_hour == null && value_day == null) {
                return null;
            }
            if (value_min == null) {
                value_min = new JSONObject();
            }
            if (value_hour == null) {
                value_hour = new JSONObject();
            }
            if (value_day == null) {
                value_day = new JSONObject();
            }
            Double fusionPCvr = this.getFusionPCvr(value_min, value_hour, value_day, ideaId);
            log.info("ocpm fusionPCvr is {} ideaId is {}", (Object)fusionPCvr, (Object)ideaId);
            return fusionPCvr;
        }
        return null;
    }

    private Double getFusionPCvr(JSONObject value_min, JSONObject value_hour, JSONObject value_day, String ideaId) {
        Optional ideaOptional = this.resourceIdeaCache.get((Object)Long.valueOf(ideaId)).getNow(Optional.empty());
        if (!ideaOptional.isPresent()) {
            SamplerLog.info((String)"getFusionPcvr \u6ca1\u6709\u627e\u5230\u521b\u610f\u8fd4\u56de\u9ed8\u8ba4\u503c ideaId is {}", (Object[])new Object[]{ideaId});
            return null;
        }
        ResourceIdeaDto resourceIdeaDto = (ResourceIdeaDto)ideaOptional.get();
        IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
        if (ideaPriceStrategyDTO == null) {
            SamplerLog.info((String)"getFusionPcvr \u6ca1\u6709\u627e\u5230\u521b\u610f\u7684\u8f6c\u5316\u7c7b\u578b ideaId is {}", (Object[])new Object[]{ideaId});
            return null;
        }
        Integer targetType = ideaPriceStrategyDTO.getTargetType();
        String str_click_min = value_min.getString("x_c");
        String str_click_hour = value_hour.getString("x_c");
        String str_click_day = value_day.getString("x_c");
        int convert_min = 0;
        int convert_hour = 0;
        int convert_day = 0;
        int click_min = 0;
        int click_hour = 0;
        int click_day = 0;
        if (StringUtils.isNotEmpty((CharSequence)str_click_min)) {
            click_min = Integer.parseInt(str_click_min);
        }
        if (StringUtils.isNotEmpty((CharSequence)str_click_hour)) {
            click_hour = Integer.parseInt(str_click_hour);
        }
        if (StringUtils.isNotEmpty((CharSequence)str_click_day)) {
            click_day = Integer.parseInt(str_click_day);
        }
        if (Objects.equals(targetType, DspTargetType.ACTIVITY_JOIN.getValue())) {
            String str_a_join_min = value_min.getString("a_j");
            String str_a_join_hour = value_hour.getString("a_j");
            String str_a_join_day = value_day.getString("a_j");
            if (StringUtils.isNotEmpty((CharSequence)str_a_join_min)) {
                convert_min = Integer.parseInt(str_a_join_min);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_a_join_hour)) {
                convert_hour = Integer.parseInt(str_a_join_hour);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_a_join_day)) {
                convert_day = Integer.parseInt(str_a_join_day);
            }
        } else if (Objects.equals(targetType, DspTargetType.ADVERT_CLICK.getValue())) {
            String str_t_click_min = value_min.getString("ef_c");
            String str_t_click_hour = value_hour.getString("ef_c");
            String str_t_click_day = value_day.getString("ef_c");
            if (StringUtils.isNotEmpty((CharSequence)str_t_click_min)) {
                convert_min = Integer.parseInt(str_t_click_min);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_t_click_hour)) {
                convert_hour = Integer.parseInt(str_t_click_hour);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_t_click_day)) {
                convert_day = Integer.parseInt(str_t_click_day);
            }
        } else if (Objects.equals(targetType, DspTargetType.LANDING_PAGE_CONVERSIONS.getValue())) {
            String str_l_convert_min = value_min.getString("l_c");
            String str_l_convert_hour = value_hour.getString("l_c");
            String str_l_convert_day = value_day.getString("l_c");
            if (StringUtils.isNotEmpty((CharSequence)str_l_convert_min)) {
                convert_min = Integer.parseInt(str_l_convert_min);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_l_convert_hour)) {
                convert_hour = Integer.parseInt(str_l_convert_hour);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_l_convert_day)) {
                convert_day = Integer.parseInt(str_l_convert_day);
            }
        } else {
            String str_convert_min = value_min.getString(String.valueOf(targetType));
            String str_convert_hour = value_hour.getString(String.valueOf(targetType));
            String str_convert_day = value_day.getString(String.valueOf(targetType));
            if (StringUtils.isNotEmpty((CharSequence)str_convert_min)) {
                convert_min = Integer.parseInt(str_convert_min);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_convert_hour)) {
                convert_hour = Integer.parseInt(str_convert_hour);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_convert_day)) {
                convert_day = Integer.parseInt(str_convert_day);
            }
        }
        log.info("\u8ba1\u7b97cvr click_day is {} click_hour is {} click_min is {} convert_day is {} convert_hour is {} convert_min is {}", new Object[]{click_day, click_hour, click_min, convert_day, convert_hour, convert_min});
        if (click_day == 0 && click_hour == 0 && click_min == 0) {
            return null;
        }
        if (convert_day < 10) {
            return null;
        }
        if (click_hour < 100 && click_day != 0) {
            return 1.0 * (double)convert_day / (double)click_day;
        }
        if (click_min < 50 && click_day != 0) {
            return 0.3 * (double)convert_day / (double)click_day + 0.7 * (double)convert_hour / (double)click_hour;
        }
        return 0.1 * (double)convert_day / (double)click_day + 0.3 * (double)convert_hour / (double)click_hour + 0.6 * (double)convert_min / (double)click_min;
    }

    private Double calculateFactor(String resourceId, String ideaId, String appId, String slotId) {
        long cpc_fee;
        long cpm_fee;
        Optional ideaOptional = this.resourceIdeaCache.get((Object)Long.valueOf(ideaId)).getNow(Optional.empty());
        if (!ideaOptional.isPresent()) {
            SamplerLog.info((String)"calculateFactor \u6ca1\u6709\u627e\u5230\u521b\u610f\u8fd4\u56de\u9ed8\u8ba4\u503c ideaId is {}", (Object[])new Object[]{ideaId});
            return null;
        }
        ResourceIdeaDto resourceIdeaDto = (ResourceIdeaDto)ideaOptional.get();
        if (resourceIdeaDto.getIdeaPriceStrategyDTO() == null) {
            SamplerLog.info((String)"calculateFactor \u6ca1\u6709\u627e\u5230\u521b\u610f\u7684\u8f6c\u5316\u7c7b\u578b ideaId is {}", (Object[])new Object[]{ideaId});
            return null;
        }
        IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
        Integer targetType = ideaPriceStrategyDTO.getTargetType();
        Double targetPrice = ideaPriceStrategyDTO.getTargetPrice();
        if (targetType == null || targetPrice == null) {
            return null;
        }
        int convert_min = 0;
        int convert_hour = 0;
        int convert_day = 0;
        String baseKey = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        String key_min = OMD + baseKey + "_" + MINUTE;
        String key_hour = OMD + baseKey + "_" + HOUR;
        String key_day = OMD + baseKey + "_" + DAY;
        Optional ideaResultMapOptional = this.omdDataCache.get((Object)baseKey).getNow(Optional.empty());
        if (!ideaResultMapOptional.isPresent()) {
            return null;
        }
        Map resultMap = (Map)ideaResultMapOptional.get();
        JSONObject value_min = resultMap.getOrDefault(key_min, new JSONObject());
        JSONObject value_hour = resultMap.getOrDefault(key_hour, new JSONObject());
        JSONObject value_day = resultMap.getOrDefault(key_day, new JSONObject());
        String cpm_fee_min = value_min.getString("x_m_f");
        String cpm_fee_hour = value_hour.getString("x_m_f");
        String cpm_fee_day = value_day.getString("x_m_f");
        String cpc_fee_min = value_min.getString("x_c_f");
        String cpc_fee_hour = value_hour.getString("x_c_f");
        String cpc_fee_day = value_day.getString("x_c_f");
        long fee_min = 0L;
        long fee_hour = 0L;
        long fee_day = 0L;
        if (StringUtils.isNotEmpty((CharSequence)cpm_fee_min)) {
            cpm_fee = Long.parseLong(cpm_fee_min);
            fee_min = cpm_fee / 10000000L;
            if (StringUtils.isNotEmpty((CharSequence)cpc_fee_min)) {
                cpc_fee = Long.parseLong(cpc_fee_min);
                fee_min += cpc_fee / 10000000L;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)cpm_fee_hour)) {
            cpm_fee = Long.parseLong(cpm_fee_hour);
            fee_hour = cpm_fee / 10000000L;
            if (StringUtils.isNotEmpty((CharSequence)cpc_fee_hour)) {
                cpc_fee = Long.parseLong(cpc_fee_hour);
                fee_hour += cpc_fee / 10000000L;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)cpm_fee_day)) {
            cpm_fee = Long.parseLong(cpm_fee_day);
            fee_day = cpm_fee / 10000000L;
            if (StringUtils.isNotEmpty((CharSequence)cpc_fee_day)) {
                cpc_fee = Long.parseLong(cpc_fee_day);
                fee_day += cpc_fee / 10000000L;
            }
        }
        if (Objects.equals(targetType, DspTargetType.MATERIAL_CLICK.getValue())) {
            if (resultMap.get(key_min) == null && resultMap.get(key_hour) == null && resultMap.get(key_day) == null) {
                SamplerLog.info((String)"ocpm \u83b7\u53d6\u6570\u636e\u7ed3\u679c\u4e3a\u7a7a key_min {} key_hour {} key_day {}", (Object[])new Object[]{key_min, key_hour, key_day});
                return null;
            }
            SamplerLog.info((String)"ocpm key is {} key_min {} key_hour {} key_day {}", (Object[])new Object[]{baseKey, key_min, key_hour, key_day});
            Integer click_min = value_min.getInteger("x_c");
            Integer click_hour = value_hour.getInteger("x_c");
            Integer click_day = value_day.getInteger("x_c");
            if (click_min == null) {
                click_min = 0;
            }
            if (click_hour == null) {
                click_hour = 0;
            }
            if (click_day == null) {
                click_day = 0;
            }
            convert_min = click_min;
            convert_hour = click_hour;
            convert_day = click_day;
        } else if (Objects.equals(targetType, DspTargetType.ACTIVITY_JOIN.getValue())) {
            if (resultMap.get(key_min) == null && resultMap.get(key_hour) == null && resultMap.get(key_day) == null) {
                SamplerLog.info((String)"ocpm \u83b7\u53d6\u6570\u636e\u7ed3\u679c\u4e3a\u7a7a key_min {} key_hour {} key_day {}", (Object[])new Object[]{key_min, key_hour, key_day});
                return null;
            }
            Integer join_min = value_min.getInteger("a_j");
            Integer join_hour = value_hour.getInteger("a_j");
            Integer join_day = value_day.getInteger("a_j");
            if (join_min == null) {
                join_min = 0;
            }
            if (join_hour == null) {
                join_hour = 0;
            }
            if (join_day == null) {
                join_day = 0;
            }
            convert_min = join_min;
            convert_hour = join_hour;
            convert_day = join_day;
        } else if (Objects.equals(targetType, DspTargetType.ADVERT_CLICK.getValue())) {
            if (resultMap.get(key_min) == null && resultMap.get(key_hour) == null && resultMap.get(key_day) == null) {
                SamplerLog.info((String)"ocpm \u83b7\u53d6\u6570\u636e\u7ed3\u679c\u4e3a\u7a7a key_min {} key_hour {} key_day {}", (Object[])new Object[]{key_min, key_hour, key_day});
                return null;
            }
            Integer e_click_min = value_min.getInteger("ef_c");
            Integer e_click_hour = value_hour.getInteger("ef_c");
            Integer e_click_day = value_day.getInteger("ef_c");
            if (e_click_min == null) {
                e_click_min = 0;
            }
            if (e_click_hour == null) {
                e_click_hour = 0;
            }
            if (e_click_day == null) {
                e_click_day = 0;
            }
            convert_min = e_click_min;
            convert_hour = e_click_hour;
            convert_day = e_click_day;
        } else if (Objects.equals(targetType, DspTargetType.LANDING_PAGE_CONVERSIONS.getValue())) {
            if (resultMap.get(key_min) == null && resultMap.get(key_hour) == null && resultMap.get(key_day) == null) {
                SamplerLog.info((String)"ocpm \u83b7\u53d6\u6570\u636e\u7ed3\u679c\u4e3a\u7a7a key_min {} key_hour {} key_day {}", (Object[])new Object[]{key_min, key_hour, key_day});
                return null;
            }
            Integer l_convert_min = value_min.getInteger("l_c");
            Integer l_convert_hour = value_hour.getInteger("l_c");
            Integer l_convert_day = value_day.getInteger("l_c");
            if (l_convert_min == null) {
                l_convert_min = 0;
            }
            if (l_convert_hour == null) {
                l_convert_hour = 0;
            }
            if (l_convert_day == null) {
                l_convert_day = 0;
            }
            convert_min = l_convert_min;
            convert_hour = l_convert_hour;
            convert_day = l_convert_day;
        } else {
            String str_convert_min = value_min.getString(String.valueOf(targetType));
            String str_convert_hour = value_hour.getString(String.valueOf(targetType));
            String str_convert_day = value_day.getString(String.valueOf(targetType));
            if (StringUtils.isNotEmpty((CharSequence)str_convert_min)) {
                convert_min = Integer.parseInt(str_convert_min);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_convert_hour)) {
                convert_hour = Integer.parseInt(str_convert_hour);
            }
            if (StringUtils.isNotEmpty((CharSequence)str_convert_day)) {
                convert_day = Integer.parseInt(str_convert_day);
            }
        }
        String lastFactorKey_min = LAST_FACTOR + resourceId + "_" + ideaId + "_" + appId + "_" + slotId + "_" + MINUTE;
        String lastFactorKey_hour = LAST_FACTOR + resourceId + "_" + ideaId + "_" + appId + "_" + slotId + "_" + HOUR;
        String lastFactorKey_day = LAST_FACTOR + resourceId + "_" + ideaId + "_" + appId + "_" + slotId + "_" + DAY;
        ArrayList<String> factorKeys = new ArrayList<String>();
        factorKeys.add(lastFactorKey_min);
        factorKeys.add(lastFactorKey_hour);
        factorKeys.add(lastFactorKey_day);
        Map<String, String> factorMap = this.stringRedisHandler.pipelineValue(factorKeys);
        double factor_min = factorMap.get(lastFactorKey_min) == null ? 1.0 : Double.parseDouble(factorMap.get(lastFactorKey_min));
        factor_min = this.checkFactor(factor_min);
        double factor_hour = factorMap.get(lastFactorKey_hour) == null ? 1.0 : Double.parseDouble(factorMap.get(lastFactorKey_hour));
        factor_hour = this.checkFactor(factor_hour);
        double factor_day = factorMap.get(lastFactorKey_day) == null ? 1.0 : Double.parseDouble(factorMap.get(lastFactorKey_day));
        factor_day = this.checkFactor(factor_day);
        SamplerLog.info((String)"factor key is {} factor_min is {} factor_hour is {} factor_day is {} targetPrice is {} convert_day is {} fee_day is {} convert_hour is {} fee_hour is {} convert_min is {} fee_min is {} factorMap is {}", (Object[])new Object[]{baseKey, factor_min, factor_hour, factor_day, targetPrice, convert_day, fee_day, convert_hour, fee_hour, convert_min, fee_min, factorMap});
        double factor_new_day = factor_day * ((targetPrice * 100.0 * (double)convert_day - (double)fee_day) / (double)fee_day / 2.0 + 1.0);
        factor_new_day = this.checkFactor(factor_new_day);
        if (fee_day < 2000L) {
            factor_new_day = 1.0;
        }
        this.stringRedisHandler.set(lastFactorKey_day, String.valueOf(factor_new_day), 20L, TimeUnit.MINUTES);
        double factor_hour_new = factor_hour * (targetPrice * 100.0 * (double)convert_hour - (double)fee_hour) / (double)fee_hour / 2.0 + 1.0;
        factor_hour_new = this.checkFactor(factor_hour_new);
        if (fee_hour < 2000L) {
            factor_hour_new = 1.0;
        }
        this.stringRedisHandler.set(lastFactorKey_hour, String.valueOf(factor_hour_new), 20L, TimeUnit.MINUTES);
        double factor_new_min = factor_min * (targetPrice * 100.0 * (double)convert_min - (double)fee_min) / (double)fee_min / 2.0 + 1.0;
        factor_new_min = this.checkFactor(factor_new_min);
        if (fee_min < 1000L) {
            factor_new_min = 1.0;
        }
        this.stringRedisHandler.set(lastFactorKey_min, String.valueOf(factor_new_min), 20L, TimeUnit.MINUTES);
        SamplerLog.info((String)"factor key is {} factor_new_day is {} factor_hour_new is {} factor_new_min is {}", (Object[])new Object[]{baseKey, factor_new_day, factor_hour_new, factor_new_min});
        if (fee_hour < 2000L) {
            double factor = factor_new_day;
            SamplerLog.info((String)"key is {} factor is {}", (Object[])new Object[]{baseKey, factor});
            return this.checkFactor(factor);
        }
        if (fee_min < 1000L) {
            double factor = 0.3 * factor_new_day + 0.7 * factor_hour_new;
            SamplerLog.info((String)"key is {} factor is {}", (Object[])new Object[]{baseKey, factor});
            return this.checkFactor(factor);
        }
        double factor = 0.1 * factor_new_day + 0.3 * factor_hour_new + 0.6 * factor_new_min;
        SamplerLog.info((String)"key is {} factor is {}", (Object[])new Object[]{baseKey, factor});
        return this.checkFactor(factor);
    }

    private Map<String, JSONObject> getData(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        String key_min = OMD + key + "_" + MINUTE;
        String key_hour = OMD + key + "_" + HOUR;
        String key_day = OMD + key + "_" + DAY;
        keys.add(key_min);
        keys.add(key_hour);
        keys.add(key_day);
        Map<String, String> resultMap = this.stringRedisHandler.pipelineValue(keys);
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>(resultMap.size());
        for (String resultKey : resultMap.keySet()) {
            JSONObject data = JSONObject.parseObject((String)resultMap.get(resultKey));
            result.put(resultKey, data);
        }
        return result;
    }

    private Map<String, JSONObject> getOmcData(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        String key_min = key + "_" + MINUTE;
        String key_hour = key + "_" + HOUR;
        String key_day = key + "_" + DAY;
        keys.add(key_min);
        keys.add(key_hour);
        keys.add(key_day);
        Map<String, String> resultMap = this.stringRedisHandler.pipelineValue(keys);
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>(resultMap.size());
        for (String resultKey : resultMap.keySet()) {
            JSONObject data = JSONObject.parseObject((String)resultMap.get(resultKey));
            result.put(resultKey, data);
        }
        return result;
    }

    private Double calculateRoiFactor(String resourceId, String ideaId, String appId, String slotId) {
        long cpc_fee;
        long cpm_fee;
        String baseKey = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        String lastRoiFactorKey_min = LASE_ROI_FACTOR + baseKey + "_" + MINUTE;
        String lastRoiFactorKey_hour = LASE_ROI_FACTOR + baseKey + "_" + HOUR;
        String lastRoiFactorKey_day = LASE_ROI_FACTOR + baseKey + "_" + DAY;
        Optional resourceIdeaOptional = this.resourceIdeaCache.get((Object)Long.valueOf(ideaId)).getNow(Optional.empty());
        if (!resourceIdeaOptional.isPresent()) {
            return null;
        }
        ResourceIdeaDto resourceIdeaDto = (ResourceIdeaDto)resourceIdeaOptional.get();
        if (resourceIdeaDto.getRoiState() == 0 || resourceIdeaDto.getMinRoi() == null) {
            return null;
        }
        double targetRoi = resourceIdeaDto.getMinRoi() / 100.0;
        Optional resultMapOptional = this.omdDataCache.get((Object)baseKey).getNow(Optional.empty());
        if (!resultMapOptional.isPresent()) {
            return null;
        }
        Map resultMap = (Map)resultMapOptional.get();
        String key_min = OMD + baseKey + "_" + MINUTE;
        String key_hour = OMD + baseKey + "_" + HOUR;
        String key_day = OMD + baseKey + "_" + DAY;
        JSONObject value_min = resultMap.getOrDefault(key_min, new JSONObject());
        JSONObject value_hour = resultMap.getOrDefault(key_hour, new JSONObject());
        JSONObject value_day = resultMap.getOrDefault(key_day, new JSONObject());
        String cpm_fee_min = value_min.getString("x_m_f");
        String cpm_fee_hour = value_hour.getString("x_m_f");
        String cpm_fee_day = value_day.getString("x_m_f");
        String cpc_fee_min = value_min.getString("x_c_f");
        String cpc_fee_hour = value_hour.getString("x_c_f");
        String cpc_fee_day = value_day.getString("x_c_f");
        long ad_fee_min = value_min.getString("f") == null ? 0L : Long.parseLong(value_min.getString("f"));
        long ad_fee_hour = value_hour.getString("f") == null ? 0L : Long.parseLong(value_hour.getString("f"));
        long ad_fee_day = value_day.getString("f") == null ? 0L : Long.parseLong(value_day.getString("f"));
        long fee_min = 0L;
        long fee_hour = 0L;
        long fee_day = 0L;
        if (StringUtils.isNotEmpty((CharSequence)cpm_fee_min)) {
            cpm_fee = Long.parseLong(cpm_fee_min);
            fee_min = cpm_fee / 10000000L;
            if (StringUtils.isNotEmpty((CharSequence)cpc_fee_min)) {
                cpc_fee = Long.parseLong(cpc_fee_min);
                fee_min += cpc_fee / 10000000L;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)cpm_fee_hour)) {
            cpm_fee = Long.parseLong(cpm_fee_hour);
            fee_hour = cpm_fee / 10000000L;
            if (StringUtils.isNotEmpty((CharSequence)cpc_fee_hour)) {
                cpc_fee = Long.parseLong(cpc_fee_hour);
                fee_hour += cpc_fee / 10000000L;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)cpm_fee_day)) {
            cpm_fee = Long.parseLong(cpm_fee_day);
            fee_day = cpm_fee / 10000000L;
            if (StringUtils.isNotEmpty((CharSequence)cpc_fee_day)) {
                cpc_fee = Long.parseLong(cpc_fee_day);
                fee_day += cpc_fee / 10000000L;
            }
        }
        ArrayList<String> factorKeys = new ArrayList<String>();
        factorKeys.add(lastRoiFactorKey_min);
        factorKeys.add(lastRoiFactorKey_hour);
        factorKeys.add(lastRoiFactorKey_day);
        Map<String, String> factorMap = this.stringRedisHandler.pipelineValue(factorKeys);
        double factor_min = factorMap.get(lastRoiFactorKey_min) == null ? 1.0 : Double.parseDouble(lastRoiFactorKey_min);
        double factor_hour = factorMap.get(lastRoiFactorKey_hour) == null ? 1.0 : Double.parseDouble(lastRoiFactorKey_hour);
        double factor_day = factorMap.get(lastRoiFactorKey_hour) == null ? 1.0 : Double.parseDouble(lastRoiFactorKey_hour);
        factor_day = this.checkFactor(factor_day);
        factor_hour = this.checkFactor(factor_hour);
        factor_min = this.checkFactor(factor_min);
        if (fee_day == 0L || fee_hour == 0L || fee_min == 0L) {
            return null;
        }
        double factor_new_day = factor_day * ((double)ad_fee_day / (double)fee_day - targetRoi) / targetRoi / 2.0 + 1.0;
        factor_new_day = this.checkFactor(factor_new_day);
        if (fee_day < 500L) {
            factor_new_day = 1.0;
        }
        this.stringRedisHandler.set(lastRoiFactorKey_day, String.valueOf(factor_new_day), 20L, TimeUnit.MINUTES);
        double factor_hour_new = factor_hour * ((double)ad_fee_hour / (double)fee_hour - targetRoi) / targetRoi / 2.0 + 1.0;
        factor_hour_new = this.checkFactor(factor_hour_new);
        if (fee_hour < 500L) {
            factor_hour_new = 1.0;
        }
        this.stringRedisHandler.set(lastRoiFactorKey_hour, String.valueOf(factor_hour_new), 20L, TimeUnit.MINUTES);
        double factor_new_min = factor_min * ((double)ad_fee_min / (double)fee_min - targetRoi) / targetRoi / 2.0 + 1.0;
        factor_new_min = this.checkFactor(factor_new_min);
        if (fee_min < 500L) {
            factor_new_min = 1.0;
        }
        this.stringRedisHandler.set(lastRoiFactorKey_min, String.valueOf(factor_new_min), 20L, TimeUnit.MINUTES);
        if (fee_day < 500L) {
            return null;
        }
        if (fee_hour < 500L) {
            double factor = factor_day * factor_new_day;
            return this.checkFactor(factor);
        }
        if (fee_min < 500L) {
            double factor = 0.5 * factor_new_day + 0.5 * factor_hour_new;
            return this.checkFactor(factor);
        }
        double factor = 0.4 * factor_new_day + 0.2 * factor_hour_new + 0.4 * factor_new_min;
        return this.checkFactor(factor);
    }

    private double checkFactor(double factor) {
        if (factor < 0.8) {
            return 0.8;
        }
        if (factor > 2.0) {
            return 2.0;
        }
        if (Double.isNaN(factor)) {
            return 1.0;
        }
        return factor;
    }

    public Double getPCtr(String resourceId, String ideaId, String appId, String slotId) {
        String key = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        String redisKey = PCTR + key;
        Optional now = this.pCTRCache.get((Object)key).getNow(Optional.empty());
        Double pctr = null;
        if (now.isPresent()) {
            pctr = new BigDecimal((String)now.get()).setScale(7, RoundingMode.UP).doubleValue();
        }
        if (pctr != null && !Double.valueOf(DEFAULT_PCTR).equals(pctr)) {
            return pctr;
        }
        String resourceKey = resourceId + "_" + appId + "_" + slotId;
        String redisResourceKey = PCTR + resourceKey;
        now = this.pCTRCache.get((Object)resourceKey).getNow(Optional.empty());
        if (now.isPresent()) {
            pctr = new BigDecimal((String)now.get()).setScale(7, RoundingMode.UP).doubleValue();
            return pctr;
        }
        return 0.0;
    }

    public Double getPCvr(String resourceId, String ideaId, String appId, String slotId) {
        String key = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        Optional now = this.pCVRCache.get((Object)key).getNow(Optional.empty());
        Double pcvr = null;
        if (now.isPresent()) {
            pcvr = new BigDecimal((String)now.get()).setScale(7, RoundingMode.UP).doubleValue();
        }
        if (pcvr != null && pcvr != 0.02) {
            return pcvr;
        }
        return 0.0;
    }

    public double getFactor(String resourceId, String ideaId, String appId, String slotId) {
        String key = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        Optional now = this.factorCache.get((Object)key).getNow(Optional.empty());
        double factor = 1.0;
        if (now.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)now.get()))) {
            if (Double.valueOf((String)now.get()).isNaN()) {
                return factor;
            }
            factor = new BigDecimal((String)now.get()).setScale(7, RoundingMode.UP).doubleValue();
        }
        return factor;
    }

    public double getRoiFactor(String resourceId, String ideaId, String appId, String slotId) {
        String key = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        Optional now = this.roiFactorCache.get((Object)key).getNow(Optional.empty());
        double factor = 1.0;
        if (now.isPresent()) {
            factor = new BigDecimal((String)now.get()).setScale(7, RoundingMode.UP).doubleValue();
        }
        return factor;
    }

    public double getQiHangPCvr(String resourceId, String ideaId, String dspTaskId, String dspId, String dspTagId) {
        String baseKey3;
        Optional now3;
        String baseKey1 = OCD1 + resourceId + "_" + ideaId + "_" + dspTagId;
        Optional now = this.omcDataCache.get((Object)baseKey1).getNow(Optional.empty());
        if (now.isPresent()) {
            int exposure_day;
            JSONObject emptyJson = new JSONObject();
            JSONObject value_min = ((Map)now.get()).getOrDefault(baseKey1 + "_" + MINUTE, emptyJson);
            JSONObject value_hour = ((Map)now.get()).getOrDefault(baseKey1 + "_" + HOUR, emptyJson);
            JSONObject value_day = ((Map)now.get()).getOrDefault(baseKey1 + "_" + DAY, emptyJson);
            if (value_day != null && (exposure_day = value_day.getIntValue("x_e")) >= 500) {
                return this.calculateQiHangPCvr(ideaId, value_min, value_hour, value_day);
            }
        }
        if ((now3 = this.omcDataCache.get((Object)(baseKey3 = OCD3 + dspId + "_" + dspTagId + "_" + dspTaskId)).getNow(Optional.empty())).isPresent()) {
            int exposure_day;
            JSONObject emptyJson = new JSONObject();
            JSONObject value_min = ((Map)now3.get()).getOrDefault(baseKey3 + "_" + MINUTE, emptyJson);
            JSONObject value_hour = ((Map)now3.get()).getOrDefault(baseKey3 + "_" + HOUR, emptyJson);
            JSONObject value_day = ((Map)now3.get()).getOrDefault(baseKey3 + "_" + DAY, emptyJson);
            if (value_day != null && (exposure_day = value_day.getIntValue("x_e")) >= 500) {
                return this.calculateQiHangPCvr(ideaId, value_min, value_hour, value_day);
            }
        }
        return Double.parseDouble(DEFAULT_PCVR);
    }

    private double calculateQiHangPCvr(String ideaId, JSONObject value_min, JSONObject value_hour, JSONObject value_day) {
        SamplerLog.info((String)"ocpc calculateQiHangPCvr ideaId:{}, value_min:{}, value_hour:{}, value_day:{}", (Object[])new Object[]{ideaId, value_min, value_hour, value_day});
        ResourceIdeaDto resourceIdeaDto = this.getResourceIdeaByCache(ideaId);
        if (resourceIdeaDto == null) {
            return 0.0;
        }
        IdeaPriceStrategyDTO ideaPriceStrategyDTO = resourceIdeaDto.getIdeaPriceStrategyDTO();
        if (ideaPriceStrategyDTO == null) {
            SamplerLog.info((String)"getFusionPcvr \u6ca1\u6709\u627e\u5230\u521b\u610f\u7684\u8f6c\u5316\u7c7b\u578b ideaId is {}", (Object[])new Object[]{ideaId});
            return 0.0;
        }
        Integer targetType = ideaPriceStrategyDTO.getTargetType();
        if (Objects.equals(targetType, DspTargetType.MATERIAL_CLICK.getValue())) {
            return 1.0;
        }
        int click_min = value_min.getIntValue("x_c");
        int click_hour = value_hour.getIntValue("x_c");
        int click_day = value_day.getIntValue("x_c");
        int convert_min = 0;
        int convert_hour = 0;
        int convert_day = 0;
        if (Objects.equals(targetType, DspTargetType.ACTIVITY_JOIN.getValue())) {
            convert_min = value_min.getIntValue("a_j");
            convert_hour = value_hour.getIntValue("a_j");
            convert_day = value_day.getIntValue("a_j");
        } else if (Objects.equals(targetType, DspTargetType.ADVERT_CLICK.getValue())) {
            convert_min = value_min.getIntValue("ef_c");
            convert_hour = value_hour.getIntValue("ef_c");
            convert_day = value_day.getIntValue("ef_c");
        } else if (Objects.equals(targetType, DspTargetType.LANDING_PAGE_CONVERSIONS.getValue())) {
            convert_min = value_min.getIntValue("l_c");
            convert_hour = value_hour.getIntValue("l_c");
            convert_day = value_day.getIntValue("l_c");
        } else {
            convert_min = value_min.getIntValue(String.valueOf(targetType));
            convert_hour = value_hour.getIntValue(String.valueOf(targetType));
            convert_day = value_day.getIntValue(String.valueOf(targetType));
        }
        SamplerLog.info((String)"\u8ba1\u7b97 ocpc cvr click_day is {} click_hour is {} click_min is {} convert_day is {} convert_hour is {} convert_min is {}", (Object[])new Object[]{click_day, click_hour, click_min, convert_day, convert_hour, convert_min});
        if (click_day == 0 && click_hour == 0 && click_min == 0) {
            return 0.0;
        }
        if (convert_day < 10) {
            return Double.parseDouble(DEFAULT_PCVR);
        }
        if (click_hour < 100 && click_day != 0) {
            return 1.0 * (double)convert_day / (double)click_day;
        }
        if (click_min < 50 && click_day != 0) {
            return 0.3 * (double)convert_day / (double)click_day + 0.7 * (double)convert_hour / (double)click_hour;
        }
        return 0.1 * (double)convert_day / (double)click_day + 0.3 * (double)convert_hour / (double)click_hour + 0.6 * (double)convert_min / (double)click_min;
    }

    public ResourceIdeaDto getResourceIdeaByCache(String ideaId) {
        Optional<Object> optional = this.resourceIdeaCache.get((Object)Long.valueOf(ideaId)).getNow(Optional.empty());
        return optional.orElse(null);
    }

    public static void main(String[] args) throws InterruptedException {
        String resourceId = "1120";
        String ideaId = "38640";
        String appId = "testApp";
        String slotId = "10088";
        String baseKey = resourceId + "_" + ideaId + "_" + appId + "_" + slotId;
        BidStatService bidStatService = new BidStatService();
        String r_baseKey = resourceId + "_" + appId + "_" + slotId;
        bidStatService.omdDataCache.put((Object)r_baseKey, CompletableFuture.supplyAsync(() -> {
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
            JSONObject resourceMin = new JSONObject();
            JSONObject resourceHour = new JSONObject();
            JSONObject resourceDay = new JSONObject();
            String r_key_min = OMD + r_baseKey + "_" + MINUTE;
            String r_key_hour = OMD + r_baseKey + "_" + HOUR;
            String r_key_day = OMD + r_baseKey + "_" + DAY;
            resourceMin.put("x_e", (Object)"400");
            resourceMin.put("x_m_f", (Object)"0");
            resourceMin.put("x_c", (Object)"200");
            resourceMin.put("x_c_f", (Object)"0");
            resourceMin.put("f", (Object)"0");
            resourceMin.put("a_j", (Object)"0");
            resourceMin.put("ef_c", (Object)"0");
            resultMap.put(r_key_min, resourceMin);
            resourceHour.put("x_e", (Object)"400");
            resourceHour.put("x_m_f", (Object)"0");
            resourceHour.put("x_c", (Object)"200");
            resourceHour.put("x_c_f", (Object)"0");
            resourceHour.put("f", (Object)"0");
            resourceMin.put("a_j", (Object)"0");
            resourceHour.put("ef_c", (Object)"0");
            resultMap.put(r_key_hour, resourceHour);
            resourceDay.put("x_e", (Object)"400");
            resourceDay.put("x_m_f", (Object)"0");
            resourceDay.put("x_c", (Object)"300");
            resourceDay.put("x_c_f", (Object)"0");
            resourceDay.put("f", (Object)"0");
            resourceDay.put("a_j", (Object)"0");
            resourceDay.put("ef_c", (Object)"0");
            resultMap.put(r_key_day, resourceDay);
            return Optional.of(resultMap);
        }));
        bidStatService.omdDataCache.put((Object)baseKey, CompletableFuture.supplyAsync(() -> {
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
            JSONObject ideaMin = new JSONObject();
            JSONObject ideaHour = new JSONObject();
            JSONObject ideaDay = new JSONObject();
            String key_min = OMD + baseKey + "_" + MINUTE;
            String key_hour = OMD + baseKey + "_" + HOUR;
            String key_day = OMD + baseKey + "_" + DAY;
            ideaMin.put("x_e", (Object)"1000");
            ideaMin.put("x_m_f", (Object)"0");
            ideaMin.put("x_c", (Object)"100");
            ideaMin.put("x_c_f", (Object)"100000000000");
            ideaMin.put("f", (Object)"10000");
            ideaMin.put("a_j", (Object)"50");
            ideaMin.put("ef_c", (Object)"50");
            ideaMin.put("6", (Object)"50");
            resultMap.put(key_min, ideaMin);
            ideaHour.put("x_e", (Object)"5000");
            ideaHour.put("x_m_f", (Object)"0");
            ideaHour.put("x_c", (Object)"200");
            ideaHour.put("x_c_f", (Object)"100000000000");
            ideaHour.put("f", (Object)"10000");
            ideaHour.put("a_j", (Object)"100");
            ideaHour.put("ef_c", (Object)"100");
            ideaHour.put("6", (Object)"100");
            resultMap.put(key_hour, ideaHour);
            ideaDay.put("x_e", (Object)"6000");
            ideaDay.put("x_m_f", (Object)"0");
            ideaDay.put("x_c", (Object)"300");
            ideaDay.put("x_c_f", (Object)"100000000000");
            ideaDay.put("f", (Object)"10000");
            ideaDay.put("a_j", (Object)"100");
            ideaDay.put("ef_c", (Object)"200");
            ideaDay.put("6", (Object)"200");
            resultMap.put(key_day, ideaDay);
            return Optional.of(resultMap);
        }));
    }
}

