/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.constants.PddNbr;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddReqConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddRespConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
@EnableConfigurationProperties(value={PddProperties.class})
public class PddDspInvoker
extends AbstractDspCaller<PddResponse, PddRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddReqConverter pddConverter;
    @Resource
    PddRespConverter pddRespConverter;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Resource
    private PddProperties pddProperties;

    @Override
    public PddRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.pddConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    protected PddResponse invokeDsp(PddRequest pddRequest) {
        if (pddRequest == null) {
            return null;
        }
        if (pddRequest.getImp() == null || pddRequest.getImp().isEmpty()) {
            return null;
        }
        Cat.logMetricForCount((String)"\u62fc\u591a\u591aDSP\u8c03\u7528");
        try {
            return (PddResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.pddProperties.getUrl(), pddRequest), (String)"invokeDSP", (String)"pdd");
        }
        catch (ResourceAccessException e) {
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            LOGGER.error("\u62fc\u591a\u591a\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", e);
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(this.pddProperties.getAdxSecret().getBytes(), "AES"));
            return new String(Base64.getEncoder().encode(cipher.doFinal(price.toString().getBytes())));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.warn("{} \u62fc\u591a\u591a\u4ef7\u683c\u52a0\u5bc6\u5931\u8d25,secret:{}", new Object[]{this.pddProperties.getAdxId(), this.pddProperties.getAdxSecret(), e});
            return null;
        }
    }

    private PddResponse doHttpInvoke(String url, PddRequest pddRequest) {
        PddResponse body;
        HttpStatus statusCode;
        block7: {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)pddRequest, (MultiValueMap)headers);
            ResponseEntity resEntity = null;
            statusCode = null;
            body = null;
            try {
                resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, PddResponse.class, new Object[0]);
                statusCode = resEntity.getStatusCode();
                body = (PddResponse)resEntity.getBody();
            }
            catch (Exception e) {
                if (e instanceof RestClientException) break block7;
                LOGGER.warn("\u62fc\u591a\u591a\u8c03\u7528\u5f02\u5e38 response is {}", (Object)resEntity, (Object)e);
            }
        }
        if (body == null) {
            return null;
        }
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            }
            if (SamplerLog.infoFlag()) {
                SamplerLog.info((String)"\u62fc\u591a\u591aDSP\u65e0\u5185\u5bb9\u8fd4\u56de,pddRequest[{}],body[{}]", (Object[])new Object[]{JSONObject.toJSONString((Object)pddRequest), JSONObject.toJSONString((Object)body)});
            }
            return null;
        }
        if (statusCode.is5xxServerError()) {
            LOGGER.warn("\u62fc\u591a\u591aDSP\u8fd4\u56de5xx,pddRequest[{}],body[{}]", (Object)JSONObject.toJSONString((Object)pddRequest), (Object)JSONObject.toJSONString((Object)body));
            return null;
        }
        LOGGER.warn("\u62fc\u591a\u591aDSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,pddRequest[{}],body[{}]", (Object)JSONObject.toJSONString((Object)pddRequest), (Object)JSONObject.toJSONString((Object)body));
        return null;
    }

    private PddResponse handle2xx(PddResponse pddResponse) {
        Integer val;
        if (!pddResponse.getNbr().equals(0) && SamplerLog.infoFlag()) {
            SamplerLog.info((String)"\u62fc\u591a\u591aDSP\u8fd4\u56de\u4e3a\u7a7a:{}", (Object[])new Object[]{JSONObject.toJSONString((Object)pddResponse)});
        }
        if (Objects.isNull(val = pddResponse.getNbr())) {
            return null;
        }
        if (PddNbr.NBR_0.getNbr().equals(val)) {
            Cat.logMetricForCount((String)"\u62fc\u591a\u591aDSP\u8fd4\u56de");
        }
        return pddResponse;
    }

    @Override
    public AdxCommonBidResponse convertResp(PddResponse pddResponse) throws DspException {
        try {
            return this.pddRespConverter.respConvert(pddResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_3.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_3;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            url = url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }
}

