/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonContext;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonDesc;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonIcon;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonImage;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonTitle;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonVideo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IqiyiRespConvert {
    private static final Logger log = LoggerFactory.getLogger(IqiyiRespConvert.class);

    public AdxCommonBidResponse respConvert(IqiyiBid.BidResponse response) {
        if (response == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(response.getBidList())) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_16.getDspId());
        List<CommonSeatBid> commonSeatBids = this.seatConvert(response.getBidList());
        if (CollectionUtils.isEmpty(commonSeatBids)) {
            return null;
        }
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<IqiyiBid.BidResponse.Bid> bidList) {
        ArrayList<CommonSeatBid> commonSeatBidList = new ArrayList<CommonSeatBid>();
        for (IqiyiBid.BidResponse.Bid bid : bidList) {
            CommonTitle commonTitle;
            Object video;
            CommonIcon commonIcon;
            CommonImage commonImage;
            ArrayList<CommonImage> commonImageList;
            CommonVideo commonVideo;
            ArrayList<CommonVideo> commonVideoList;
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext context = new CommonContext();
            CommonCreative commonCreative = new CommonCreative();
            if (bid == null) continue;
            commonSeatBid.setPrice(Double.valueOf(bid.getPrice()));
            commonSeatBid.setAdvertiserId("50582");
            IqiyiBid.AdActionType action = bid.getAction();
            if (IqiyiBid.AdActionType.DOWNLOAD_APP.equals((Object)action)) {
                return null;
            }
            if (bid.hasOpening()) {
                if (IqiyiBid.AdActionType.OPEN_APP_DEEPLINK.equals((Object)action) || IqiyiBid.AdActionType.OPEN_IN_WEBVIEW.equals((Object)action)) {
                    IqiyiBid.BidResponse.Bid.Link link = bid.getLink();
                    context.setDeepLinkUrl(link.getDeeplink());
                    commonCreative.setLandingPageUrl(link.getCurl());
                    commonSeatBid.setExposureCallbackUrls((List<String>)link.getImptrackersList());
                    commonSeatBid.setClickCallbackUrls((List<String>)link.getClicktrackersList());
                    if (IqiyiBid.BidResponse.Bid.CreativeType.VIDEO.equals((Object)bid.getCreativeType())) {
                        commonVideoList = new ArrayList();
                        IqiyiBid.BidResponse.Bid.AdVideo adVideo = bid.getAdVideo();
                        commonVideo = new CommonVideo();
                        commonVideo.setVideoUrl(bid.getAdUrl());
                        commonVideo.setDuration(new BigDecimal(adVideo.getDuration()));
                        commonVideo.setResolutionX(bid.getAdWidth());
                        commonVideo.setResolutionY(bid.getAdHeight());
                        commonVideoList.add(commonVideo);
                        commonCreative.setCommonVideoList(commonVideoList);
                    } else if (IqiyiBid.BidResponse.Bid.CreativeType.IMG.equals((Object)bid.getCreativeType())) {
                        commonImageList = new ArrayList();
                        CommonImage commonImage2 = new CommonImage();
                        commonImage2.setUrl(bid.getAdUrl());
                        commonImage2.setWidth(bid.getAdWidth());
                        commonImage2.setHeight(bid.getAdHeight());
                        commonImageList.add(commonImage2);
                        commonCreative.setCommonImageList(commonImageList);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)bid.getTitle())) {
                    CommonTitle commonTitle2 = new CommonTitle();
                    commonTitle2.setTitle(bid.getTitle());
                    commonCreative.setCommonTitle(commonTitle2);
                }
                if (StringUtils.isNotBlank((CharSequence)bid.getDescription())) {
                    CommonDesc commonDesc = new CommonDesc();
                    commonDesc.setDesc(bid.getDescription());
                    commonCreative.setCommonDesc(commonDesc);
                }
            }
            if (bid.hasAdVideo()) {
                IqiyiBid.BidResponse.Bid.AdmVideo admvideo = bid.getAdmvideo();
                if (CollectionUtils.isNotEmpty(admvideo.getImgsList())) {
                    commonImageList = new ArrayList<CommonImage>();
                    for (IqiyiBid.BidResponse.Bid.Image image2 : admvideo.getImgsList()) {
                        if (IqiyiBid.BidResponse.Bid.Image.ImageAssetType.MAIN.equals((Object)image2.getType())) {
                            commonImage = new CommonImage();
                            commonImage.setUrl(image2.getUrl());
                            commonImage.setWidth(image2.getW());
                            commonImage.setHeight(image2.getH());
                            commonImageList.add(commonImage);
                            commonCreative.setCommonImageList(commonImageList);
                        }
                        if (!IqiyiBid.BidResponse.Bid.Image.ImageAssetType.ICON.equals((Object)image2.getType())) continue;
                        commonIcon = new CommonIcon();
                        commonIcon.setUrl(image2.getUrl());
                        commonCreative.setIconUrl(image2.getUrl());
                        commonCreative.setCommonIcon(commonIcon);
                    }
                }
                if (admvideo.hasVideo()) {
                    commonVideoList = new ArrayList<CommonVideo>();
                    video = admvideo.getVideo();
                    commonVideo = new CommonVideo();
                    commonVideo.setVideoUrl(((IqiyiBid.BidResponse.Bid.Video)video).getUrl());
                    commonVideo.setResolutionX(((IqiyiBid.BidResponse.Bid.Video)video).getW());
                    commonVideo.setResolutionY(((IqiyiBid.BidResponse.Bid.Video)video).getH());
                    if (((IqiyiBid.BidResponse.Bid.Video)video).hasDuration()) {
                        commonVideo.setDuration(new BigDecimal(((IqiyiBid.BidResponse.Bid.Video)video).getDuration()));
                    }
                    commonVideoList.add(commonVideo);
                    commonCreative.setCommonVideoList(commonVideoList);
                }
                if (admvideo.hasTitle()) {
                    commonTitle = new CommonTitle();
                    commonTitle.setTitle(admvideo.getTitle());
                    commonCreative.setCommonTitle(commonTitle);
                }
                if (admvideo.hasDesc()) {
                    CommonDesc commonDesc = new CommonDesc();
                    commonDesc.setDesc(admvideo.getDesc());
                    commonCreative.setCommonDesc(commonDesc);
                }
                commonCreative.setAppBundle(admvideo.getPackageName());
                commonCreative.setAppName(admvideo.getAppName());
            }
            if (bid.hasAdmnative()) {
                IqiyiBid.BidResponse.Bid.AdmNative admnative = bid.getAdmnative();
                if (StringUtils.isNotBlank((CharSequence)admnative.getTitle())) {
                    commonTitle = new CommonTitle();
                    commonTitle.setTitle(admnative.getTitle());
                    commonCreative.setCommonTitle(commonTitle);
                }
                if (CollectionUtils.isNotEmpty(admnative.getImgsList())) {
                    commonImageList = new ArrayList();
                    for (IqiyiBid.BidResponse.Bid.Image image2 : admnative.getImgsList()) {
                        if (IqiyiBid.BidResponse.Bid.Image.ImageAssetType.MAIN.equals((Object)image2.getType())) {
                            commonImage = new CommonImage();
                            commonImage.setUrl(image2.getUrl());
                            commonImage.setWidth(image2.getW());
                            commonImage.setHeight(image2.getH());
                            commonImageList.add(commonImage);
                        }
                        if (!IqiyiBid.BidResponse.Bid.Image.ImageAssetType.ICON.equals((Object)image2.getType())) continue;
                        commonIcon = new CommonIcon();
                        commonIcon.setUrl(image2.getUrl());
                        commonCreative.setIconUrl(image2.getUrl());
                        commonCreative.setCommonIcon(commonIcon);
                    }
                    commonCreative.setCommonImageList(commonImageList);
                }
                if (admnative.hasVideo()) {
                    commonVideoList = new ArrayList();
                    video = admnative.getVideo();
                    commonVideo = new CommonVideo();
                    commonVideo.setVideoUrl(((IqiyiBid.BidResponse.Bid.Video)video).getUrl());
                    commonVideo.setVideoUrl(((IqiyiBid.BidResponse.Bid.Video)video).getUrl());
                    commonVideo.setResolutionX(((IqiyiBid.BidResponse.Bid.Video)video).getW());
                    commonVideo.setResolutionY(((IqiyiBid.BidResponse.Bid.Video)video).getH());
                    if (((IqiyiBid.BidResponse.Bid.Video)video).hasDuration()) {
                        commonVideo.setDuration(new BigDecimal(((IqiyiBid.BidResponse.Bid.Video)video).getDuration()));
                    }
                    commonVideoList.add(commonVideo);
                    commonCreative.setCommonVideoList(commonVideoList);
                }
                if (admnative.hasLink()) {
                    IqiyiBid.BidResponse.Bid.Link link = admnative.getLink();
                    context.setDeepLinkUrl(link.getDeeplink());
                    commonCreative.setLandingPageUrl(link.getCurl());
                    commonSeatBid.setExposureCallbackUrls((List<String>)link.getImptrackersList());
                    commonSeatBid.setClickCallbackUrls((List<String>)link.getClicktrackersList());
                }
                commonCreative.setAppBundle(admnative.getPackageName());
                commonCreative.setAppName(admnative.getAppName());
            }
            if (StringUtils.isBlank((CharSequence)commonCreative.getAppName())) {
                commonCreative.setAppName(bid.getAppName());
            }
            if (StringUtils.isBlank((CharSequence)commonCreative.getAppBundle())) {
                commonCreative.setAppBundle(bid.getApkName());
            }
            commonSeatBidList.add(commonSeatBid);
            commonSeatBid.setCommonContext(context);
            commonSeatBid.setCommonCreative(commonCreative);
        }
        return commonSeatBidList;
    }
}

