package cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.App;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Device;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.Imp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruishi.bean.RuiShiReq;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Component
public class RuiShiReqConvert {
    @Autowired
    private AppReplace appReplace;

    public RuiShiReq convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        RuiShiReq ruiShiReq = new RuiShiReq();
        ruiShiReq.setId(adxCommonBidRequest.getRequestId());
        List<Imp> imps = convertImp(adxCommonBidRequest, dspInfo);
        if (CollectionUtils.isEmpty(imps)) {
            return null;
        }
        ruiShiReq.setImp(imps);
        App app = convertApp(adxCommonBidRequest, dspInfo);
        ruiShiReq.setApp(app);
        Device device = convertDevice(adxCommonBidRequest, dspInfo);
        ruiShiReq.setDevice(device);
        return ruiShiReq;
    }

    private Device convertDevice(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Device device = new Device();
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
        device.setDevicetype(4);
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        if (StringUtils.isNotBlank(commonDevice.getOs())) {
            if ("0".equals(commonDevice.getOs())) {
                device.setOs("android");
            }
            if ("1".equals(commonDevice.getOs())) {
                device.setOs("ios");
            }
        }
        device.setOsv(commonDevice.getOsVersion());
        device.setDidmd5(commonDevice.getImeiMd5());
        if (commonDevice.getCarrier() != null) {
            if (Objects.equals(commonDevice.getCarrier(), "1")) {
                device.setCarrier("mobile");
            }
            if (Objects.equals(commonDevice.getCarrier(), "2")) {
                device.setCarrier("unicom");
            }
            if (Objects.equals(commonDevice.getCarrier(), "3")) {
                device.setCarrier("telecom");
            }
        }
        device.setRegion("CN");
        device.setLang("zh_CN");
        device.setOaIdMd5(commonDevice.getOaIdMd5());
        device.setBoot_mark(commonDevice.getBootTime());
        device.setUpdate_mark(commonDevice.getUpdateTime());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        List<Caid> caids = commonDevice.getCaids();
        if (CollectionUtils.isNotEmpty(caids)) {
            for (Caid caid : caids) {
                if (caid.getVersion().equals("20220111")) {
                    device.setCaid(caid.getId());
                    device.setCaidv(caid.getVersion());
                    break;
                }
            }
        }
        if (commonDevice.getPaid() != null) {
            device.setPaid(commonDevice.getPaid());
        }

        return device;
    }

    private App convertApp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        App app = new App();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setBundle(replaceApp.getBundle());
        } else {
            if (appInfo.getName() != null) {
                app.setName(appInfo.getName());
            }
            app.setBundle(appInfo.getBundle());
        }
        app.setVer(appInfo.getVersion());
        return app;
    }

    private List<Imp> convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        if (commonImp == null) {
            return null;
        }
        List<Imp> imps = new ArrayList<>();
        Imp imp = new Imp();
        imp.setId(commonImp.getId());
        imp.setTagid(dspInfo.getDspTagId());
        imp.setAdx_tagid(commonImp.getTagId());
        imp.setDeepLink(1);
        imp.setImpType(dspInfo.getDspResId());
        if (commonImp.isLinkAgreement()) {
            imp.setSecure(1);
        } else {
            imp.setSecure(0);
        }
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setBidfloor((int) floorPrice);

        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        imp.setWidth(commonSizeInfo.getWidth());
        imp.setHeight(commonSizeInfo.getHeight());

        imps.add(imp);
        return imps;
    }
}
