/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.HuichuanProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter.HuichuanRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter.HuichuanResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.resp.HuichuanResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.Key;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class HuichuanDspInvoker
extends AbstractDspCaller<HuichuanResponse, AdRequest> {
    private static final Logger log = LoggerFactory.getLogger(HuichuanDspInvoker.class);
    private static final String TOKEN = "d6797b0f95f8ead2";
    @Resource
    private HuichuanRequestConverter huichuanRequestConverter;
    @Resource
    private HuichuanResponseConverter huichuanResponseConverter;
    @Resource
    private HuichuanProperties huichuanProperties;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected HuichuanResponse invokeDsp(AdRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u8d85\u7ea7\u6c47\u5dddDSP\u8c03\u7528");
        try {
            return (HuichuanResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.huichuanProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"huichuan");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u8d85\u7ea7\u6c47\u5ddd_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u8d85\u7ea7\u6c47\u5ddd\u7ade\u4ef7\u5931\u8d25", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private HuichuanResponse doHttpInvoke(String url, AdRequest rtbRequest) throws IOException {
        Charset utf8 = Consts.UTF_8;
        byte[] paramByte = JSON.toJSONString((Object)rtbRequest).getBytes(utf8);
        byte[] requestByte = new byte[paramByte.length + 16];
        requestByte[1] = 2;
        System.arraycopy(paramByte, 0, requestByte, 16, paramByte.length);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)requestByte, (MultiValueMap)headers);
        try {
            ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class, new Object[0]);
            org.springframework.core.io.Resource resource = (org.springframework.core.io.Resource)resEntity.getBody();
            if (resource == null) {
                return null;
            }
            HttpStatus statusCode = resEntity.getStatusCode();
            byte[] responseBytes = IOUtils.toByteArray((InputStream)resource.getInputStream());
            if (responseBytes == null || responseBytes.length <= 16) {
                SamplerLog.info((String)"\u8d85\u7ea7\u6c47\u5dddDSP\u5185\u5bb9\u8fd4\u56de\u4e0d\u89c4\u8303,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest});
                return null;
            }
            byte[] response = new byte[responseBytes.length - 16];
            System.arraycopy(responseBytes, 16, response, 0, response.length);
            HuichuanResponse huichuanResponse = (HuichuanResponse)JSON.parseObject((String)new String(response, utf8), HuichuanResponse.class);
            if (HttpStatus.OK.value() == statusCode.value()) {
                if (huichuanResponse.getCode().equals(0)) {
                    Cat.logMetricForCount((String)"\u8d85\u7ea7\u6c47\u5dddDSP\u8fd4\u56de");
                    return huichuanResponse;
                }
                SamplerLog.info((String)"\u8d85\u7ea7\u6c47\u5dddDSP\u8fd4\u56de\u9519\u8bef\u7801\u6216\u8005\u51b7\u542f\u52a8,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, huichuanResponse});
                Cat.logMetricForCount((String)"\u8d85\u7ea7\u6c47\u5dddDSP\u8fd4\u56de\u9519\u8bef\u7801");
                return null;
            }
            if (statusCode.is5xxServerError()) {
                Cat.logMetricForCount((String)"\u8d85\u7ea7\u6c47\u5ddd\u8fd4\u56de5xx");
                SamplerLog.info((String)"\u8d85\u7ea7\u6c47\u5ddd\u8fd4\u56de5xx,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, huichuanResponse});
                return null;
            }
            Cat.logMetricForCount((String)"\u8d85\u7ea7\u6c47\u5ddd\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801");
            SamplerLog.info((String)"\u8d85\u7ea7\u6c47\u5ddd\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,pddRequest[{}],body[{}]", (Object[])new Object[]{rtbRequest, huichuanResponse});
            return null;
        }
        catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                SamplerLog.warn((String)"\u8d85\u7ea7\u6c47\u5ddd\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] raw = TOKEN.getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            IvParameterSpec iv = new IvParameterSpec(raw);
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(price.toString().getBytes("utf-8"));
            byte[] encodeBase64 = Base64.encodeBase64URLSafe((byte[])encrypted);
            return new String(encodeBase64, "utf-8");
        }
        catch (Exception e) {
            log.warn("RgyunDspInvoker \u4ef7\u683c\u89e3\u5bc6\u5931\u8d25");
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_21.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_21;
    }

    @Override
    public AdRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.huichuanRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(HuichuanResponse rtbResponse) throws DspException {
        try {
            return this.huichuanResponseConverter.respConvert(rtbResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }
}

