package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;

/**
 * 计算底价
 */
public class CalculateFloorPrice {

    public static long getFloorPrice(double floorPrice, DspInfo dspInfo) {
        if (dspInfo.getDspFloorType() == null || dspInfo.getDspFloorPrice() == null) {
            return Math.round(floorPrice * (dspInfo.getMinRoi() / 100));
        }
        //固定底价处理
        if (dspInfo.getDspFloorType() == 1) {
            return dspInfo.getDspFloorPrice();
        }
        //动态底价
        if (dspInfo.getDspFloorType() == 0) {
            return Math.round(floorPrice * dspInfo.getDspFloorPrice() / 10000);
        }
        return Math.round(floorPrice * (dspInfo.getMinRoi() / 100));
    }
}
