package cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class CommonVideo {

    /**
     * 主键id：互动为视频主键id；直投则为样+式素材id
     */
    private Long id;

    /**
     * 视频广告 Url
     */
    private String videoUrl;

    /**
     * 视频大小 ( 单位 :: Byte )
     */
    private Integer size;

    /**
     * 视频单位 ( 单位 :: Byte )
     */
    private String unit;

    /**
     * 视频时长 ( 单位 :: Secend/秒 )
     */
    private BigDecimal duration;

    /**
     * 视频分辨率水平显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720
     */
    private Integer resolutionX;

    /**
     * 视频分辨率垂直显示每英寸点（ dpi ）的数量
     * 如: ( x ) 1280 x ( y ) 720
     */
    private Integer resolutionY;

    /**
     * 视频封面图片 Url
     */
    private String coverUrl;

    /**
     * 视频封面图片宽度
     */
    private Integer coverWidth;

    /**
     * 视频封面图片高度
     */
    private Integer coverHeight;
}
