package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 计算cpm
 */
@Service
@Slf4j
public class CalculatorCpmService {
    @Autowired
    private BidStatService bidStatService;

    public static final String DEFAULT_PCTR = "0.20";
    public static final String DEFAULT_PCVR = "0.10";

    /**
     * cpc出价转为cpm
     */
    public double cpc2Cpm(Double price, AdxCommonBidResponse adxCommonBidResponse) {
        CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
        AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
        ResourceIdeaDto resourceIdeaDto = bidStatService.getResourceIdeaByCache(String.valueOf(adxCommonBidResponse.getIdeaId()));
        if (resourceIdeaDto == null) {
            return 0;
        }
        String appId = commonBidRequest.getBaiduAppId();
        String slotId = commonBidRequest.getExternalAdBlockId();
        String resourceId = String.valueOf(resourceIdeaDto.getResourceId());
        String ideaId = String.valueOf(adxCommonBidResponse.getIdeaId());

        Double pCtr = bidStatService.getPCtr(resourceId, ideaId, appId, slotId);
        double factor = bidStatService.getFactor(resourceId, ideaId, appId, slotId);
        if (factor == 0.0) {
            factor = 1.0;
        }
        if (pCtr == 0.0) {
            pCtr = Double.parseDouble(DEFAULT_PCTR);
        }
        SamplerLog.info("cpc2Cpm appId is {} slotId is {} resourceId is {} ideaId is {} cpcPrice is {} pctr is {} factor is {}", appId, slotId, resourceId, ideaId, price, pCtr, factor);
        return price * pCtr * 1000 * factor;
    }

    /**
     * 计算推啊出价ocpm 维稳过的cpm出价
     */
    public double calculateOcpm(AdxCommonBidResponse adxCommonBidResponse) {
        CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
        AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
        ResourceIdeaDto resourceIdeaDto = bidStatService.getResourceIdeaByCache(String.valueOf(adxCommonBidResponse.getIdeaId()));
        if (resourceIdeaDto == null) {
            return 0;
        }
        String appId = commonBidRequest.getBaiduAppId();
        String slotId = commonBidRequest.getExternalAdBlockId();
        String resourceId = String.valueOf(resourceIdeaDto.getResourceId());
        String ideaId = String.valueOf(adxCommonBidResponse.getIdeaId());
        Double pCtr = bidStatService.getPCtr(resourceId, ideaId, appId, slotId);
        double pCvr = bidStatService.getPCvr(resourceId, ideaId, appId, slotId);
        double factor = bidStatService.getFactor(resourceId, ideaId, appId, slotId);
        //默认值校验
        if (factor == 0.0) {
            factor = 1.0;
        }
        if (pCtr == 0.0) {
            pCtr = Double.parseDouble(DEFAULT_PCTR);
        }
        if (pCvr == 0.0) {
            pCvr = Double.parseDouble(DEFAULT_PCVR);
        }
        Double targetPrice = resourceIdeaDto.getIdeaPriceStrategyDTO().getTargetPrice();
        SamplerLog.info("calculateOcpm appId is {} slotId is {} resourceId is {} ideaId is {} targetPrice is {} pctr is {} pcvr is {} factor is {}", appId, slotId, resourceId, ideaId, targetPrice, pCtr, pCvr, factor);
        return targetPrice * 100 * pCtr * pCvr * factor * 1000;
    }

    /*
     * 推啊ocpc 返回cpm
     */
    public double calculateOcpc(ResourceIdeaDto resourceIdeaDto, AdxCommonBidResponse adxCommonBidResponse) {
        CommonSeatBid commonSeatBid = adxCommonBidResponse.getCommonSeatBidList().get(0);
        AdxCommonBidRequest commonBidRequest = commonSeatBid.getCommonBidRequest();
        CommonCreative commonCreative = commonSeatBid.getCommonCreative();
        String appId = commonBidRequest.getBaiduAppId();
        String slotId = commonBidRequest.getExternalAdBlockId();
        String dspTaskId = commonCreative.getDspTaskId();
        String resourceId = String.valueOf(resourceIdeaDto.getResourceId());
        String ideaId = String.valueOf(adxCommonBidResponse.getIdeaId());
        String dspId = String.valueOf(resourceIdeaDto.getDspId());
        String dspTagId = resourceIdeaDto.getDspTagId();
        double pCvr = bidStatService.getQiHangPCvr(resourceId, ideaId, dspTaskId, dspId, dspTagId);
        double pCtr = bidStatService.getPCtr(resourceId, ideaId, appId, slotId);
        Double targetPrice = resourceIdeaDto.getIdeaPriceStrategyDTO().getTargetPrice();
        double factor = bidStatService.getFactor(resourceId, ideaId, appId, slotId);
        Integer dspPriceRatio = resourceIdeaDto.getDspPriceRatio();
        //默认值校验
        if (factor == 0.0) {
            factor = 1.0;
        }
        if (pCtr == 0.0) {
            pCtr = Double.parseDouble(DEFAULT_PCTR);
        }
        if (pCvr == 0.0) {
            pCvr = Double.parseDouble(DEFAULT_PCVR);
        }
        //计算cpc出价
        double cpcPrice = targetPrice * 100 * pCvr * factor;

        if (dspPriceRatio != null) {
            cpcPrice = cpcPrice * (1 - (double) dspPriceRatio / 100) + commonSeatBid.getPrice() * dspPriceRatio / 100 * factor;
        }
        commonSeatBid.setPrice(cpcPrice);
        SamplerLog.info("calculateOcpc appId is {} slotId is {} resourceId is {} ideaId is {} targetPrice is {} pctr is {} pcvr is {} factor is {}", appId, slotId, resourceId, ideaId, targetPrice, pCtr, pCvr, factor);
        return targetPrice * 100 * pCtr * pCvr * factor * 1000;
    }
}
