package cn.com.duiba.tuia.dsp.engine.api.enums;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspInvoker;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * dspId 对应的竞价url
 *
 * @author lijian
 * @date 2020/04/13
 * @since JDK 1.8
 */
public enum DspMappingEnum {


    /*DSP_1(1L, "http://172.16.47.169:17788/adxAdvert/comparePrice", "ab3128977c94a115f64d64cb5ba4379c", "58同城"),*/
//    DSP_2(2L, "京准通", null),
    DSP_3(3L, "拼多多", null);

    private final Long dspId;

    //dsp平台名称
    private final String desc;

    private final Class<? extends AbstractDspInvoker> clazz;

    DspMappingEnum(Long dspId, String desc, Class<? extends AbstractDspInvoker> clazz) {
        this.dspId = dspId;
        this.desc = desc;
        this.clazz = clazz;
    }

    public Long getDspId() {
        return dspId;
    }

    public String getDesc() {
        return desc;
    }

    public Class<? extends AbstractDspInvoker> getClazz() {
        return clazz;
    }

    private static Map<Long, DspMappingEnum> dspMap = Maps.newHashMap();

    static {
        for (DspMappingEnum it : DspMappingEnum.values()) {
            dspMap.put(it.getDspId(), it);
        }
    }

    public static DspMappingEnum getByDspId(Long dspId) {
        return dspMap.get(dspId);
    }

}
