/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCallbackRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.DigestAuthUtil;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.JinghongProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean.Jinghong;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter.JinghongRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter.JinghongResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class JinghongDspInvoker
extends AbstractDspCaller<Jinghong.AdResponse, Jinghong.AdRequest> {
    private static final Logger log = LoggerFactory.getLogger(JinghongDspInvoker.class);
    @Resource
    private JinghongRequestConverter jinghongRequestConverter;
    @Resource
    private JinghongResponseConverter jinghongResponseConverter;
    @Resource
    private JinghongProperties jinghongProperties;
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected Jinghong.AdResponse invokeDsp(Jinghong.AdRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u9cb8\u9e3f\u52a8\u80fdDSP\u8c03\u7528");
        try {
            return (Jinghong.AdResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.jinghongProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"jinghong");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u9cb8\u9e3f\u52a8\u80fd_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof SocketTimeoutException) && !(t instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u9cb8\u9e3f\u52a8\u80fd\u7ade\u4ef7\u5931\u8d25", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private Jinghong.AdResponse doHttpInvoke(String url, Jinghong.AdRequest rtbRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String authHeader = DigestAuthUtil.getPostReqDigestHeader("/ppsadx/getResult", this.jinghongProperties.getKey(), this.jinghongProperties.getPublisherId(), this.jinghongProperties.getKeyId());
        headers.add("Authorization", authHeader);
        HttpEntity entity = new HttpEntity((Object)rtbRequest, (MultiValueMap)headers);
        Jinghong.AdResponse response = (Jinghong.AdResponse)this.restTemplate.postForObject(url, (Object)entity, Jinghong.AdResponse.class, new Object[0]);
        if (response == null) {
            return null;
        }
        if (Integer.valueOf(200).equals(response.getRetcode())) {
            Cat.logMetricForCount((String)"\u9cb8\u9e3f\u52a8\u80fdDSP\u8fd4\u56de");
            return response;
        }
        SamplerLog.info((String)"\u9cb8\u9e3f\u52a8\u80fddsp \u8fd4\u56de {}", (Object[])new Object[]{JSON.toJSONString((Object)response)});
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return String.valueOf(price);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_24.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_24;
    }

    @Override
    public Jinghong.AdRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return this.jinghongRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(Jinghong.AdResponse rtbResponse) throws DspException {
        try {
            return this.jinghongResponseConverter.respConvert(rtbResponse);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        return url;
    }

    @Override
    protected void replaceReturnMacro(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo, AdxCommonBidResponse commonBidResponse) {
        CommonSeatBid commonSeatBid = commonBidResponse.getCommonSeatBidList().get(0);
        List<String> exposureCallbackUrls = commonSeatBid.getExposureCallbackUrls();
        CommonImp commonImp = commonBidRequest.getImpList().get(0);
        Integer w = commonImp.getW();
        Integer h = commonImp.getH();
        for (int i = 0; i < exposureCallbackUrls.size(); ++i) {
            String url = exposureCallbackUrls.get(i);
            if (w != null && h != null) {
                url = url.replace("__HW_W__", String.valueOf(w)).replace("__HW_H__", String.valueOf(h));
            }
            exposureCallbackUrls.set(i, url);
        }
        List<String> clickCallbackUrls = commonSeatBid.getClickCallbackUrls();
        CommonDevice commonDevice = commonBidRequest.getDevice();
        int ppi = commonDevice.getPpi();
        for (int i = 0; i < clickCallbackUrls.size(); ++i) {
            String url = clickCallbackUrls.get(i);
            if (w != null && h != null) {
                url = url.replace("__HW_W__", String.valueOf(w)).replace("__HW_H__", String.valueOf(h));
            }
            if (ppi != 0) {
                url = url.replace("__HW_DENSITY__", String.valueOf(ppi));
            }
            clickCallbackUrls.set(i, url);
        }
    }

    @Override
    public String replaceEventMacro(String url, CommonCallbackRequest callbackRequest) {
        int activeSlide;
        if (callbackRequest == null) {
            return url;
        }
        if (callbackRequest.getTimeStamp() == 0L) {
            return url;
        }
        Integer type = callbackRequest.getType();
        if (type == 0) {
            return url.replace("__HW_EVENT_TIME__ ", String.valueOf(callbackRequest.getTimeStamp()));
        }
        if (callbackRequest.getAdW() != 0 && callbackRequest.getAdH() != 0) {
            url = url.replace("__HW_W__", String.valueOf(callbackRequest.getAdW()));
            url = url.replace("__HW_H__", String.valueOf(callbackRequest.getAdH()));
        }
        if (callbackRequest.getDpi() != 0) {
            url = url.replace("__HW_DENSITY__", String.valueOf(callbackRequest.getDpi()));
        }
        if ((activeSlide = callbackRequest.getActiveSlide()) == 0 || activeSlide == 1 || activeSlide == 6) {
            if (callbackRequest.getAdClickDownX() == 0 && callbackRequest.getAdClickDownY() == 0) {
                callbackRequest.setAdClickDownX(-999);
                callbackRequest.setAdClickDownY(-999);
            }
            if (callbackRequest.getAdClickUpX() == 0 && callbackRequest.getAdClickUpY() == 0) {
                callbackRequest.setAdClickUpX(-999);
                callbackRequest.setAdClickUpY(-999);
            }
            url = url.replace("__HW_DOWN_X__", String.valueOf(callbackRequest.getAdClickDownX())).replace("__HW_DOWN_Y__", String.valueOf(callbackRequest.getAdClickDownY())).replace("__HW_UP_X__", String.valueOf(callbackRequest.getAdClickUpX())).replace("__HW_UP_Y__", String.valueOf(callbackRequest.getAdClickUpY()));
        }
        if (activeSlide == 2) {
            url = url.replace("__HW_X_MAX_ACC__", String.valueOf(callbackRequest.getShakeMaxAccelX())).replace("__HW_Y_MAX_ACC__", String.valueOf(callbackRequest.getShakeMaxAccelY())).replace("__HW_Z_MAX_ACC__", String.valueOf(callbackRequest.getShakeMaxAccelZ()));
        }
        url = url.replace("__HW_SLD__", String.valueOf(activeSlide)).replace("__HW_DOWN_TIME__", String.valueOf(callbackRequest.getTimeStamp()));
        return url;
    }
}

