package cn.com.duiba.tuia.dsp.engine.api.dsp.huijia;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.util.CatUtils;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.resp.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Slf4j
@Component
public class HuiJiaDspInvoker extends AbstractDspCaller<BidResponse, BidRequest> {

    @Autowired
    private TuiaReqConvert reqConvert;
    @Autowired
    private TuiaRespConvert respConvert;

    @Autowired
    private HuiJiaDspProperties huiJiaDspProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;


    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null){
            return null;
        }
        Cat.logMetricForCount("天津汇佳DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(huiJiaDspProperties.getUrl(), bidRequest), "invokeDSP", "huijia");
        } catch (Throwable t) {
            Cat.logMetricForCount("天津汇佳_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("天津汇佳_调用异常", t);
            }
        }
        return null;
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity<BidRequest> requestEntity = new HttpEntity<>(bidRequest, headers);
        ResponseEntity<BidResponse> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, BidResponse.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("天津汇佳调用异常 response is {}", resEntity, e);
            }
        }
        if (resEntity == null) {
            return null;
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        if (statusCode == HttpStatus.NO_CONTENT) {
            return null;
        }
        SamplerLog.info("天津汇佳 DSP返回 {}", resEntity);
        Cat.logMetricForCount("天津汇佳DSP返回");
        return resEntity.getBody();
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        String key = "OCGE8AUhK2f6qdbriUG5QP7z7wGiCki5";
        String code = price.toString();
        byte[] keyBytes = key.getBytes();
        try {
            SecretKeySpec sckeySpec = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, sckeySpec);
            byte[] encrypted = cipher.doFinal(code.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encrypted);
        } catch (Exception e) {
            log.warn("天津汇佳加密失败", e);
        }
        return "";
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_28.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_28;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            return url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse == null) {
            return null;
        }
        bidResponse.setDspId(getDspId());
        return respConvert.convert(bidResponse);
    }
}
