package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean;

import lombok.Data;

import java.util.List;

@Data
public class AdInfo {
    private String requestId;
    //广告类型: 1:横幅广告 2:插屏广告 3:开屏广告 4:信息流广告 5:激励视频广告 6:全屏视频 7:插屏视频 8:新插屏
    private Integer adType;
    //广告操作行为: 0:无交互
    //1:H5
    //3:Deeplink 唤醒 4:下载类 5:打开微信小程序 6:广点通下载
    private Integer interactionType;
    //广告标题文案
    private String title;
    //广告描述文案
    private String desc;
    //广告图标地址
    private List<String> adIcons;
    private String deeplink;
    private String universalLink;
    private String landingPageUrl;
    //快手落地页
    private String kwaiLandingPageUrl;
    //应用商店直投 url schema，为空则代表没有直 投
    private String marketUrl;
    //单位 分
    private Integer bidPrice;
    //竞胜上报链接
    private List<String> winNoticeUrls;
    //竞败上报链接
    private List<String> lossNoticeUrls;
    //广告物料-应用信息
    private AppRsp app;
    //广告物料-视频信息
    private Video video;
    //广告物料-广告图片
    private List<Image> images;
    //微信小程序信息，当 interactionType=5 时有值
    private MiniProgram miniProgram;
    //广告效果监测信息
    private Track track;
}
