package cn.com.duiba.tuia.dsp.engine.api.log;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

/**
 * Created by hong
 * time 2024/1/23.
 */
@Slf4j
public class DspReturnLog {
    private final static DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String GROUP = "group";

    public static final String TYPE = "type";

    public static final String TIME = "time";

    public static final String JSON = "json";
    /**
     * Log.
     *
     * @param json the json
     */
    public static void log(String json) {
        JSONObject jsonLog = new JSONObject();
        jsonLog.put(GROUP, 1);
        jsonLog.put(TYPE, 198);
        jsonLog.put(TIME, getSecondStr());
        jsonLog.put("uuid", UUID.randomUUID().toString().replaceAll("-", ""));
        jsonLog.put(JSON, json);
        if (!PerfTestUtils.isPerfTestEnv()) {
            log.info(jsonLog.toJSONString());
        }

    }

    /**
     * 获取"yyyy-MM-dd HH:mm:ss"字符串
     * @return
     */
    public static String getSecondStr() {
        LocalDateTime currentTime = LocalDateTime.now();
        return dtf.format(currentTime);
    }
}
