package cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.adx.center.api.dto.ResourceIdeaDto;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.BidStatService;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.proto.AlipayDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class AlipayDspReqConvert {
    @Autowired
    private AppReplace appReplace;
    @Autowired
    private BidStatService bidStatService;

    public AlipayDsp.BidRequest convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        AlipayDsp.BidRequest.Builder builder = AlipayDsp.BidRequest.newBuilder();
        builder.setId(adxCommonBidRequest.getRequestId());
        AlipayDsp.BidRequest.Imp.Builder imp = convertImp(adxCommonBidRequest, dspInfo);
        builder.addImp(imp);

        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        AlipayDsp.BidRequest.Device.Builder device = convertDevice(commonDevice);
        builder.setDevice(device);

        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        AlipayDsp.BidRequest.App.Builder appInfoBuilder = convertAppInfo(appInfo, dspInfo);
        builder.setApp(appInfoBuilder);

        builder.setTimeout(200);

        return builder.build();
    }

    private AlipayDsp.BidRequest.Imp.Builder convertImp(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        AlipayDsp.BidRequest.Imp.Builder imp = AlipayDsp.BidRequest.Imp.newBuilder();
        CommonImp commonImp = commonBidRequest.getImpList().get(0);
        imp.setId(commonImp.getId());
        imp.setTagId(dspInfo.getDspTagId());
        imp.setAdType(Integer.parseInt(dspInfo.getDspResId()));
        imp.setBidType(0);

        AlipayDsp.BidRequest.Imp.Asset.Builder asset = AlipayDsp.BidRequest.Imp.Asset.newBuilder();
        asset.setTemplateId(dspInfo.getDspTemplateId());
        imp.addAsset(asset);
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        imp.setCpmBidFloor(floorPrice);
        imp.addAdStyles(1);
        imp.addAdStyles(2);
        imp.addAdStyles(3);
        imp.addAdStyles(4);

        return imp;
    }

    private AlipayDsp.BidRequest.Device.Builder convertDevice(CommonDevice commonDevice) {
        AlipayDsp.BidRequest.Device.Builder device = AlipayDsp.BidRequest.Device.newBuilder();
        String ua = commonDevice.getUa();
        if (StringUtils.isNotBlank(ua)) {
            device.setUa(ua);
        }
        device.setIp(commonDevice.getIp());
        Integer tuiaDeviceType = commonDevice.getTuiaDeviceType();
        device.setDeviceType(0);
        if (tuiaDeviceType != null) {
            if (tuiaDeviceType == 1) {
                device.setDeviceType(4);
            }
            if (tuiaDeviceType == 2) {
                device.setDeviceType(2);
            }
            if (tuiaDeviceType == 3) {
                device.setDeviceType(6);
            }
        }
        if (StringUtils.isNotBlank(commonDevice.getMake())) {
            device.setMake(commonDevice.getMake());
        }
        if (StringUtils.isNotBlank(commonDevice.getModel())) {
            device.setModel(commonDevice.getModel());
        }
        if (StringUtils.isNotBlank(commonDevice.getIdFa())) {
            device.setIdfa(commonDevice.getIdFa());
        }
        if (StringUtils.isNotBlank(commonDevice.getIdFaMd5())) {
            device.setIdfaMd5(commonDevice.getIdFaMd5());
        }
        if (StringUtils.isNotBlank(commonDevice.getOaId())) {
            device.setOaid(commonDevice.getOaId());
        }
        if (StringUtils.isNotBlank(commonDevice.getOaIdMd5())) {
            device.setOaidMd5(commonDevice.getOaIdMd5());
        }
        if (StringUtils.isNotBlank(commonDevice.getImei())) {
            device.setImei(commonDevice.getImei());
        }
        if (StringUtils.isNotBlank(commonDevice.getImeiMd5())) {
            device.setImeiMd5(commonDevice.getImeiMd5());
        }
        String os = commonDevice.getOs();
        device.setOs("android");
        if ("1".equals(os)) {
            device.setOs("ios");
        }
        device.setOsv(commonDevice.getOsVersion());
        String carrier = commonDevice.getCarrier();
        device.setCarrier(0);
        if ("1".equals(carrier)) {
            device.setCarrier(1);
        } else if ("2".equals(carrier)) {
            device.setCarrier(2);
        } else if ("3".equals(carrier)) {
            device.setCarrier(3);
        }

        Integer tuiaConnectionType = commonDevice.getTuiaConnectionType();
        device.setConnectionType(tuiaConnectionType);
        if (StringUtils.isNotBlank(commonDevice.getDpId())) {
            device.setAndroidId(commonDevice.getDpId());
        }
        if (StringUtils.isNotBlank(commonDevice.getDpIdMd5())) {
            device.setAndroidIdMd5(commonDevice.getDpIdMd5());
        }
        if (StringUtils.isNotBlank(commonDevice.getMac())) {
            device.setMac(commonDevice.getMac());
        }
        if (StringUtils.isNotBlank(commonDevice.getMacMd5())) {
            device.setMacMd5(commonDevice.getMacMd5());
        }
        List<Caid> caids = commonDevice.getCaids();
        if (CollectionUtils.isNotEmpty(caids)) {
            for (Caid caid : caids) {
                AlipayDsp.BidRequest.Device.CaidInfo.Builder caidInfo = AlipayDsp.BidRequest.Device.CaidInfo.newBuilder();
                caidInfo.setCaid(caid.getId());
                caidInfo.setVersion(caid.getVersion());
                device.addCaidInfos(caidInfo);
            }
        }
        if (StringUtils.isNotBlank(commonDevice.getBootTime())) {
            device.setBootMark(commonDevice.getBootTime());
        }
        if (StringUtils.isNotBlank(commonDevice.getUpdateTime())) {
            device.setUpdateMark(commonDevice.getUpdateTime());
        }

        return device;
    }

    private AlipayDsp.BidRequest.App.Builder convertAppInfo(CommonAppInfo commonAppInfo, DspInfo dspInfo) {
        AlipayDsp.BidRequest.App.Builder app = AlipayDsp.BidRequest.App.newBuilder();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setBundle(replaceApp.getBundle());
            app.setName(replaceApp.getName());
        } else {
            app.setBundle(commonAppInfo.getBundle());
            app.setName(commonAppInfo.getName());
        }
        return app;
    }


}
