package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.TanxResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.net.SocketTimeoutException;

import java.util.Base64;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;

@Slf4j
@Component
public class TanxDspInvoker extends AbstractDspCaller<TanxBiddingResponse.Response, TanxBiddingRequest.Request> {

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Autowired
    private TanxRequestConvert tanxRequestConvert;
    @Autowired
    private TanxResponseConvert tanxResponseConvert;
    @Autowired
    private TanxProperties tanxProperties;

    @Override
    protected TanxBiddingResponse.Response invokeDsp(TanxBiddingRequest.Request tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(tanxProperties.getUrl(), tanxBiddingRequest), "invokeDSP", "tanx");
        } catch (Throwable t) {
            Cat.logMetricForCount("tanx_竞价失败");
            if (!(t instanceof SocketTimeoutException || t instanceof ResourceAccessException)) {
                SamplerLog.warn("tanxDSP调用异常", t);
            }
            return null;
        }
    }

    private TanxBiddingResponse.Response doHttpInvoke(String url, TanxBiddingRequest.Request tanxBiddingRequest) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/octet-stream");
        HttpEntity<byte[]> requestEntity = new HttpEntity<>(tanxBiddingRequest.toByteArray(), headers);
        SamplerLog.info("tanx doHttpInvoke rtbRequest:{}", tanxBiddingRequest);
        Cat.logMetricForCount("tanxDSP调用");
        ResponseEntity<org.springframework.core.io.Resource> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
        } catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn("tanxDSP调用异常", e);
            }
            return null;
        }
        org.springframework.core.io.Resource resource = resEntity.getBody();
        if (resource == null) {
            return null;
        }
        TanxBiddingResponse.Response response = TanxBiddingResponse.Response.parseFrom(resource.getInputStream());
        if (CollectionUtils.isNotEmpty(response.getSeatList())) {
            Cat.logMetricForCount("tanxDSP返回");
        }
        return response;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();

        try {
            //将price转为16进制并补齐为4字节
            String hexPrice = String.format("%08X", Integer.parseInt(tme));

            //将hexString转为byte数组
            byte[] hexBytes = Hex.decodeHex(hexPrice.toCharArray());

            String bidid = DigestUtils.md5Hex(getAdxRid());
            byte[] bytes3 = Hex.decodeHex(bidid.toCharArray());
            //将bytes2拼接到bytes3后面
            byte[] bytes4 = new byte[bytes3.length + hexBytes.length];
            System.arraycopy(bytes3, 0, bytes4, 0, bytes3.length);
            System.arraycopy(hexBytes, 0, bytes4, bytes3.length, hexBytes.length);


            String token = "9c62ef1eef3d9ff42ebab4f169c8a4ca";
            byte[] bytes1 = Hex.decodeHex(token.toCharArray());
            SecretKeySpec secretKey = new SecretKeySpec(bytes1, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);

            byte[] bytes = cipher.doFinal(bytes4);


            tme = Base64.getUrlEncoder().encodeToString(bytes);
            if (tme.contains("=")) {
                tme = tme.replace("=", "");
            }
            return tme;
        } catch (Exception e) {
            log.warn("tanx加密失败 ", e);
        }
        return null;
    }

    public String int32ToHexStr(int num) {
        // 使用ByteBuffer转换为网络字节序（大端序）
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(num);
        // 反转数组以获取大端序字节
        byte[] data = buffer.array();

        // 使用StringBuilder构建hex字符串
        StringBuilder hexBuilder = new StringBuilder();
        for (byte b : data) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hex = "0" + hex; // 确保每个字节都是两位数
            }
            hexBuilder.append(hex);
        }
        return hexBuilder.toString();
    }

    public String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public String hex2str(String hexStr) {
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < hexStr.length(); i += 2) {
            String hex = hexStr.substring(i, i + 2);
            int decimal = Integer.parseInt(hex, 16);
            encoded.append((char) decimal);
        }
        return encoded.toString();
    }

    public static void main(String[] args) {


//        System.out.println("price is: " + 1500);
//
//        String enprice_aes = new TanxDspInvoker().int32ToHexStr(1500);
//        String bidid_bin = new TanxDspInvoker().string2Hex("abc45678901234561234567890123456");
//        String aes_key = new TanxDspInvoker().string2Hex("12345678901234561234567890123456");
//
//        System.out.printf("before EncryptAes128Ecb_bin, %s\n", enprice_aes);
//        System.out.printf("encrypt_key, %s, hex is \n",
//                aes_key, new TanxDspInvoker().string2Hex(aes_key));
//        System.out.printf("bidid_bin, %s, \n",
//                bidid_bin);
//
//        String encrypt_value = bidid_bin + enprice_aes;
//        System.out.printf("encrypt_value, %s, \n",
//                encrypt_value, new TanxDspInvoker().string2Hex(encrypt_value));
////
////
////
////
////
//        String token = new TanxDspInvoker().string2Hex("9c62ef1eef3d9ff42ebab4f169c8a4ca");
//        String bidId = new TanxDspInvoker().string2Hex("abc45678901234561234567890123456");
//        String price = new TanxDspInvoker().int32ToHexStr(1500);
//        //将price转为16进制并补齐为4字节
//        StringBuilder hexPrice = new StringBuilder(Integer.toHexString(Integer.parseInt("1500")));
//        while (hexPrice.length() < 8) {
//            hexPrice.insert(0, "0");
//        }
////
//        String price1 = String.format("%08X", 1500);
//        System.out.println(price1);
////        new TanxDspInvoker().string2Hex();
////        System.out.println(price);
////        System.out.println(hexPrice);
////
////
////
//        String tme = "";
//        System.out.println(bidId + price);
//        try {
//            String hexString = Integer.toHexString(1500);
//            //将hexString转为byte数组
//            byte[] hexBytes = Hex.decodeHex(hexPrice.toString().toCharArray());
////
////
////
//            byte[] bytes2 = Hex.decodeHex("1500".toCharArray());
////
//            System.out.println(new String(bytes2));
////
////
//            byte[] bytes3 = Hex.decodeHex("9c62ef1eef3d9ff42ebab4f169c8a4ca".toCharArray());
//            //将bytes2拼接到bytes3后面
//            byte[] bytes4 = new byte[bytes3.length + hexBytes.length];
//            System.arraycopy(bytes3, 0, bytes4, 0, bytes3.length);
//            System.arraycopy(hexBytes, 0, bytes4, bytes3.length, hexBytes.length);
//            System.out.println("aaaaaaaaa" + new String(bytes4));
//            System.out.println("aaaaaaaaa" + new String(bytes3));
////
//            byte[] bytes1 = Hex.decodeHex("12345678901234561234567890123456".toCharArray());
//            System.out.println(new String(bytes1));
//            System.out.println(token);
////
//            SecretKeySpec secretKey = new SecretKeySpec(bytes1, "AES");
//            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
//            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
////
//            byte[] bytes = cipher.doFinal(bytes4);
//            System.out.println(new String(bytes));
////
////
//            tme = Base64.getUrlEncoder().encodeToString(bytes);
//            if (tme.contains("=")) {
//                tme = tme.replace("=", "");
//            }
//            System.out.println(tme);
////            byte[] decode = org.apache.commons.codec.binary.Base64.encodeBase64URLSafe.decode(tme);
////            System.out.println(new String(decode));
//        } catch (Exception e) {
//            log.warn("tanx加密失败 ", e);
//        }
        TanxDspInvoker tanxDspInvoker = new TanxDspInvoker();
        tanxDspInvoker.setAdxRid("abc45678901234561234567890123456");
        String s = tanxDspInvoker.priceEncryption(new BigDecimal(1500));
        System.out.println(s);

    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_5.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_5;
    }


    private int str2hex(char c) {
        if (c >= '0' && c <= '9') {
            return c - '0';
        } else if (c >= 'a' && c <= 'f') {
            return c - 'a' + 10;
        } else if (c >= 'A' && c <= 'F') {
            return c - 'A' + 10;
        } else {
            return 0;
        }
    }

    public String string2Hex(String str) {
        // 必须是2的倍数
        if (str.length() % 2 != 0) {
            return "";
        }

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i += 2) {
            int high = str2hex(str.charAt(i));
            int low = str2hex(str.charAt(i + 1));
            int num = (high << 4) | low;
            sb.append((char) num);
        }
        return sb.toString();
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__AUCTION_PRICE__") && price != null) {
            url = url.replaceAll("__AUCTION_PRICE__", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public TanxBiddingRequest.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return tanxRequestConvert.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(TanxBiddingResponse.Response tanxBiddingResponse) throws DspException {
        try {
            return tanxResponseConvert.respConvert(tanxBiddingResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}
